/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.itemstate;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;

public class BaseItemStateSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseItemStateSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.select(TradingDay.Properties.DATE, "trading_day").select(SalesLocation.Properties.LABEL, "location");
        query.linkUsing(SalesItemQuantity.Properties.SALES_LOCATION).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM);
        for (Pair<Object, String> nextState : this.getDynamicColumns()) {
            StringBuilder SB;
            if (((String)nextState.value).endsWith("_count")) {
                SB = new StringBuilder("SUM(IF(sales_item_quantity.item_state = '");
                SB.append(nextState.key).append("', 1, 0)) as `").append((String)nextState.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (!((String)nextState.value).endsWith("_total")) continue;
            SB = new StringBuilder("ROUND(SUM(IF(sales_item_quantity.item_state = '");
            SB.append(nextState.key).append("', (sales_component.unit_price * sales_item_quantity.quantity), 0)), 2) as `").append((String)nextState.value).append("`");
            query.selectFunc(SB.toString());
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList("trading_day", "location"));
        return toReturn;
    }

    @Override
    protected List<Pair<Object, String>> createDynamicColumns() {
        ArrayList<Pair<Object, String>> dyns = new ArrayList<Pair<Object, String>>();
        for (String nextState : SalesItemQuantity.ALL_STATES) {
            this.addDynamicColumn(dyns, nextState, nextState);
        }
        return dyns;
    }

    @Override
    protected String getColumnNamePairSQL() {
        return null;
    }
}

