/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.labour;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.departments.Department;
import ordermate.database.finance.timesheet.TimesheetSummaryReport;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.labour.BaseLabourSearcher;

public class BaseLabourCompiler
extends AbstractBaseReportCompiler {
    private BaseLabourSearcher searcher;
    private Map<String, Map<Object, TimesheetSummaryReport>> perDepartmentMap;
    private Map<Object, TimesheetSummaryReport> totals;
    private PropertiedObject.Property groupingProperty;
    private Map<String, PropertiedObject.Property> propertyMap;

    @Override
    public void compile() {
        this.searcher = this.createSearcher();
        this.searcher.setGroupBy(this.getGrouping());
        this.searcher.getTradingDayFilter().setStart(this.getStartDate());
        this.searcher.getTradingDayFilter().setEnd(this.getEndDate());
        this.doSearch();
    }

    private void doSearch() {
        List<TimesheetSummaryReport> reports = this.searcher.search();
        this.perDepartmentMap = new HashMap<String, Map<Object, TimesheetSummaryReport>>();
        List<Department> depts = this.getActiveDepartments();
        for (Department department : depts) {
            if (this.perDepartmentMap.containsKey(department.getLabel())) continue;
            this.perDepartmentMap.put(department.getLabel(), new HashMap());
        }
        this.totals = new HashMap<Object, TimesheetSummaryReport>();
        this.fillMaps(reports);
    }

    private void fillMaps(List<TimesheetSummaryReport> reports) {
        for (TimesheetSummaryReport report : reports) {
            Object id = this.getIdentifier(report);
            this.perDepartmentMap.get(report.getDepartment().getLabel()).put(id, report);
            if (!this.totals.containsKey(id)) {
                this.totals.put(id, new TimesheetSummaryReport());
            }
            this.totals.get(id).addReport(report);
        }
    }

    private Object getIdentifier(TimesheetSummaryReport report) {
        if (this.groupingProperty != null) {
            return report.getPropertyValue(this.groupingProperty);
        }
        return null;
    }

    @Override
    protected BaseLabourSearcher createSearcher() {
        this.searcher = new BaseLabourSearcher();
        this.searcher.setQueryMods(CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType));
        return this.searcher;
    }

    @Override
    public void setGrouping(BaseReportGrouping grouping) {
        super.setGrouping(grouping);
        if (BaseReportGrouping.StoreId.equals((Object)grouping)) {
            this.groupingProperty = TimesheetSummaryReport.Properties.STORE_ID;
        } else if (BaseReportGrouping.TradingDay.equals((Object)grouping)) {
            this.groupingProperty = TimesheetSummaryReport.Properties.REPORT_DATE;
        } else {
            if (BaseReportGrouping.SalesLocation.equals((Object)grouping)) {
                throw new IllegalArgumentException("Labour report cannot be grouped to SalesLocation - Not implemented");
            }
            this.groupingProperty = null;
        }
    }

    @Override
    public Object getValue(Object rowId, String column) {
        TimesheetSummaryReport report;
        this.getPropertyMap();
        PropertiedObject.Property prop = this.propertyMap.get(column);
        if (prop != null && (report = this.totals.get(rowId)) != null) {
            return report.getPropertyValue(prop);
        }
        return null;
    }

    @Override
    public List<String> getDirectColumns() {
        this.getPropertyMap();
        List<String> cols = this.getExtraSelects();
        cols.addAll(new ArrayList<String>(this.propertyMap.keySet()));
        Collections.sort(cols);
        return cols;
    }

    private List<Department> getActiveDepartments() {
        return PersistenceManager.getObjectList(Department.class, Query.select(Department.class).active(Department.class).toString());
    }

    private void getPropertyMap() {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, PropertiedObject.Property>();
            HashSet<PropertiedObject.Property> inc = new HashSet<PropertiedObject.Property>(TimesheetSummaryReport.Properties.getPropertySet());
            inc.remove(TimesheetSummaryReport.Properties.ID);
            inc.remove(TimesheetSummaryReport.Properties.VERSION);
            inc.remove(TimesheetSummaryReport.Properties.STORE_ID);
            inc.remove(TimesheetSummaryReport.Properties.DEPARTMENT);
            inc.remove(TimesheetSummaryReport.Properties.PAYRATE);
            inc.remove(TimesheetSummaryReport.Properties.REPORT_DATE);
            inc.remove(TimesheetSummaryReport.Properties.USER);
            inc.remove(TimesheetSummaryReport.Properties.MOD_COUNT);
            inc.add(TimesheetSummaryReport.Properties.TOTAL_HOURS);
            inc.add(TimesheetSummaryReport.Properties.AVERAGE_PAY);
            for (Department nextDept : this.getActiveDepartments()) {
                for (PropertiedObject.Property nextKey : inc) {
                    this.propertyMap.put(nextDept + "-" + nextKey.getName(), nextKey);
                }
            }
            for (PropertiedObject.Property nextKey : inc) {
                this.propertyMap.put("Total-" + nextKey.getName(), nextKey);
            }
        }
    }

    @Override
    public Set getRowIdentifiers() {
        return this.totals.keySet();
    }

    @Override
    public BaseReport getBaseReport() {
        return BaseReport.Labour;
    }
}

