/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.labour;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.Date;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.finance.timesheet.TimesheetSummaryReport;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.BaseReportGrouping;

public class BaseLabourSearcher
extends PropertySearcher<TimesheetSummaryReport> {
    private IRangedQuerySearchFilter<Date> dayFilter;
    private BaseReportGrouping groupBy = BaseReportGrouping.None;

    public BaseLabourSearcher() {
        super(TimesheetSummaryReport.class);
        this.dayFilter = new RangeJoinSearchFilter<Date>(new RangeQuerySearchFilter(TradingDay.Properties.DATE), FinanceTimesheet.Properties.TRADING_DAY);
        this.addSearchFilter(this.dayFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(FinanceTimesheet.Properties.TRADING_DAY, "ID").sum(FinanceTimesheet.Properties.TOTAL_PAY, "total_pay").sum(FinanceTimesheet.Properties.TOTAL_SECONDS, "total_seconds").select(FinanceTimesheet.Properties.DEPARTMENT, "fk_config_department").select(TradingDay.Properties.DATE, "report_date").selectFunc("NULL as 'fk_config_user'").selectFunc("NULL as 'fk_config_payrate'").select(TradingDay.Properties.DATE, "total_date").selectFunc("0 as mod_count").linkUsing(FinanceTimesheet.Properties.TRADING_DAY).groupBy(FinanceTimesheet.Properties.DEPARTMENT);
        this.addGroupBy(query);
        return query;
    }

    private void addGroupBy(ObjectQuery query) {
        if (BaseReportGrouping.StoreId.equals((Object)this.groupBy)) {
            query.groupBy(FinanceTimesheet.Properties.STORE_ID);
        } else if (BaseReportGrouping.TradingDay.equals((Object)this.groupBy)) {
            query.groupBy(FinanceTimesheet.Properties.TRADING_DAY);
        }
    }

    public void setGroupBy(BaseReportGrouping groupBy) {
        this.groupBy = groupBy;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }
}

