/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.patrons;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class BasePPASearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BasePPASearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.selectFunc(" CONCAT(config_user.FirstName, ' ', config_user.Surname) as user").sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total").selectFunc("SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) as total_ex").selectFunc("SUM(IF(sales_component.item_discount_total IS NULL,0, sales_component.item_discount_total) + IF(sales_component.account_discount_total IS NULL,0, sales_component.account_discount_total)) as total_discounts").selectFunc("SUM(IF(sales_component.item_surcharge_total IS NULL,0, sales_component.item_surcharge_total) + IF(sales_component.account_surcharge_total IS NULL,0, sales_component.account_surcharge_total)) as total_surcharges").sum(Account.Properties.NUM_PATRONS, "patrons").selectFunc(this.getSelectDayPartQuery("sales_item_quantity.creation_time"));
        query.select(TradingDay.Properties.DATE, "trading_day").select(SalesLocation.Properties.LABEL, "location");
        query.linkUsing(SalesItemQuantity.Properties.SALES_LOCATION).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.INVENTORY_ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItem.Properties.CATEGORY, InventoryCategory.Properties.ID).wherePropertyIn(Account.Properties.ACCOUNT_TYPE, new AccountType[]{AccountType.tableType, AccountType.onlineTableType});
        for (Pair<Object, String> nextCategory : this.getDynamicColumns()) {
            StringBuilder sb;
            if (((String)nextCategory.value).endsWith("_count")) {
                sb = new StringBuilder("SUM(IF(inventory_item.fk_inventory_category = ");
                sb.append(nextCategory.key).append(", sales_item_quantity.quantity, 0)) as `").append((String)nextCategory.value).append("`");
                query.selectFunc(sb.toString());
                continue;
            }
            if (!((String)nextCategory.value).endsWith("_total")) continue;
            sb = new StringBuilder("ROUND(SUM(IF(inventory_item.fk_inventory_category = ");
            sb.append(nextCategory.key).append(", (sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity, 0)), 2) as `").append((String)nextCategory.value).append("`");
            query.selectFunc(sb.toString());
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("user", "total", "total_ex", "total_discounts", "total_surcharges", "patrons", "day_part", "trading_day", "location");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "SELECT ID, Name FROM inventory_category cat where cat.system_state = 'ACTIVE' ORDER BY cat.Name";
    }
}

