/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.patrons;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.DatedReportHelper;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.patrons.BasePatronsByAccountTypeSearcher;
import ordermate.database.sales.AccountType;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.MultiKeyMap;

public class BasePatronsByAccountTypeCompiler
extends AbstractBaseReportCompiler {
    private static final String CURRENT = "Current-";
    private static final String PREVIOUS = "Previous-";
    private static final String LAST_YEAR = "LastYear-";
    private BasePatronsByAccountTypeSearcher searcher;
    private MultiKeyMap now;
    private MultiKeyMap previous;
    private MultiKeyMap lastYear;
    private PropertiedObject.Property groupingProperty;
    private Map<String, PropertiedObject.Property> propertyMap;
    private List<String> columnList;

    @Override
    public void setGrouping(BaseReportGrouping grouping) {
        super.setGrouping(grouping);
        this.groupingProperty = BaseReportGrouping.StoreId.equals((Object)grouping) ? AccountTotalsReport.Properties.STORE_ID : (BaseReportGrouping.TradingDay.equals((Object)grouping) ? AccountTotalsReport.Properties.TOTAL_DATE : (BaseReportGrouping.SalesLocation.equals((Object)grouping) ? AccountTotalsReport.Properties.LOCATION : null));
    }

    @Override
    public void compile() {
        this.searcher = this.createSearcher();
        this.searcher.setGroupBy(this.getGrouping());
        this.searcher.getTradingDayFilter().setStart(this.getStartDate());
        this.searcher.getTradingDayFilter().setEnd(this.getEndDate());
        this.now = new MultiKeyMap();
        this.fillMap(this.now);
        this.searcher.getTradingDayFilter().setStart(this.getPreviousStart());
        this.searcher.getTradingDayFilter().setEnd(this.getPreviousEnd());
        this.previous = new MultiKeyMap();
        this.fillMap(this.previous);
        this.searcher.getTradingDayFilter().setStart(this.getLastYearStart());
        this.searcher.getTradingDayFilter().setEnd(this.getLastYearEnd());
        this.lastYear = new MultiKeyMap();
        this.fillMap(this.lastYear);
        this.getPropertyMap();
    }

    @Override
    protected BasePatronsByAccountTypeSearcher createSearcher() {
        this.searcher = new BasePatronsByAccountTypeSearcher();
        this.searcher.setQueryMods(CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType));
        return this.searcher;
    }

    private void fillMap(MultiKeyMap map) {
        List reports = this.searcher.search();
        Calendar cal = null;
        if (this.groupingProperty == AccountTotalsReport.Properties.TOTAL_DATE && map != this.now) {
            cal = Calendar.getInstance();
        }
        for (AccountTotalsReport report : reports) {
            map.put(this.getIdentifier(report, cal, (Map<Object, AccountTotalsReport>)map), (Object)report.getAccountType(), (Object)report);
        }
    }

    private Object getIdentifier(AccountTotalsReport report, Calendar cal, Map<Object, AccountTotalsReport> map) {
        if (this.groupingProperty != null) {
            if (cal == null) {
                return report.getPropertyValue(this.groupingProperty);
            }
            Date date = (Date)report.getPropertyValue(this.groupingProperty);
            if (map == this.lastYear) {
                return DatedReportHelper.moveForwardAYear(date);
            }
            if (map == this.previous) {
                return DatedReportHelper.moveForwardAPeriod(date, this.getAdapter());
            }
        }
        return null;
    }

    @Override
    public Object getValue(Object rowId, String column) {
        AccountType type = this.resolveAccountType(column);
        if (column.contains(CURRENT)) {
            return this.valueOf((AccountTotalsReport)this.now.get(rowId, (Object)type), column);
        }
        if (column.contains(PREVIOUS)) {
            return this.valueOf((AccountTotalsReport)this.previous.get(rowId, (Object)type), column);
        }
        if (column.contains(LAST_YEAR)) {
            return this.valueOf((AccountTotalsReport)this.lastYear.get(rowId, (Object)type), column);
        }
        return null;
    }

    private AccountType resolveAccountType(String value) {
        for (AccountType type : AccountType.TYPES) {
            if (!value.startsWith(type.getLabel())) continue;
            return type;
        }
        return null;
    }

    private Object valueOf(AccountTotalsReport report, String property) {
        if (report != null) {
            PropertiedObject.Property prop = this.propertyMap.get(property);
            if (prop == null) {
                throw new IllegalStateException("Unknown property");
            }
            return report.getPropertyValue(prop);
        }
        return null;
    }

    @Override
    public List<String> getDirectColumns() {
        if (this.columnList == null) {
            this.getPropertyMap();
            this.columnList = this.getExtraSelects();
            this.columnList.addAll(this.propertyMap.keySet());
        }
        return this.columnList;
    }

    private void getPropertyMap() {
        HashSet<PropertiedObject.Property> excludedProps = new HashSet<PropertiedObject.Property>();
        excludedProps.add(AccountTotalsReport.Properties.TOTAL_ADJUSTMENTS);
        excludedProps.add(AccountTotalsReport.Properties.ACCOUNT_STATE);
        excludedProps.add(AccountTotalsReport.Properties.ID);
        excludedProps.add(AccountTotalsReport.Properties.VERSION);
        excludedProps.add(AccountTotalsReport.Properties.STORE_ID);
        excludedProps.add(AccountTotalsReport.Properties.TOTAL_TAX);
        excludedProps.add(AccountTotalsReport.Properties.TOTAL_DATE);
        excludedProps.add(AccountTotalsReport.Properties.COUNT);
        excludedProps.add(AccountTotalsReport.Properties.DAY_PART);
        excludedProps.add(AccountTotalsReport.Properties.MOD_COUNT);
        this.propertyMap = new HashMap<String, PropertiedObject.Property>();
        for (PropertiedObject.Property prop : AccountTotalsReport.Properties) {
            if (excludedProps.contains(prop)) continue;
            String modWord = StringUtils.firstCharToUpperCase(prop.getName());
            this.propertyMap.put(CURRENT + modWord, prop);
            this.propertyMap.put(PREVIOUS + modWord, prop);
            this.propertyMap.put(LAST_YEAR + modWord, prop);
        }
        HashMap<String, PropertiedObject.Property> realMap = new HashMap<String, PropertiedObject.Property>();
        HashSet<String> keySet = new HashSet<String>(this.propertyMap.keySet());
        for (AccountType nextType : AccountType.TYPES) {
            for (String nextKey : keySet) {
                realMap.put(nextType.getLabel() + "-" + nextKey, this.propertyMap.get(nextKey));
            }
        }
        this.propertyMap = realMap;
    }

    @Override
    public Set getRowIdentifiers() {
        HashSet identifiers = new HashSet();
        this.addIdentifiers(identifiers, this.now);
        this.addIdentifiers(identifiers, this.previous);
        this.addIdentifiers(identifiers, this.lastYear);
        return identifiers;
    }

    private void addIdentifiers(Set idSet, MultiKeyMap map) {
        Set keys = map.keySet();
        for (MultiKey entry : keys) {
            idSet.add(entry.getKey(0));
        }
    }

    @Override
    public BaseReport getBaseReport() {
        return BaseReport.Patrons;
    }
}

