/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.patrons;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.Date;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class BasePatronsByAccountTypeSearcher
extends PropertySearcher<AccountTotalsReport> {
    private IRangedQuerySearchFilter<Date> dayFilter;
    private BaseReportGrouping groupBy = BaseReportGrouping.None;

    public BasePatronsByAccountTypeSearcher() {
        super(AccountTotalsReport.class);
        this.dayFilter = new RangeJoinSearchFilter<Date>(new RangeQuerySearchFilter(TradingDay.Properties.DATE), Account.Properties.TRADING_DAY);
        this.addSearchFilter(this.dayFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.selectFunc("MAX(" + Account.Properties.ACCOUNT_STATE + ") as account_state").select(Account.Properties.ID, "ID").select(Account.Properties.ACCOUNT_TYPE, "acc_type").count(Account.class, "count").sum(Account.Properties.SAVED_TOTAL, "total").selectFunc("0 as 'total_adjustments'").selectFunc(" 0 as 'total_tax'").select(TradingDay.Properties.DATE, "total_date").sum(Account.Properties.NUM_PATRONS, "total_patrons").selectFunc("0 as mod_count").linkUsing(Account.Properties.TRADING_DAY).groupBy(Account.Properties.ACCOUNT_TYPE);
        if (BaseReportGrouping.SalesLocation.equals((Object)this.groupBy)) {
            query.select(SalesItemQuantity.Properties.SALES_LOCATION, "fk_config_sales_location").joinFunction("JOIN sales_item on sales_item.id = (SELECT ID from sales_item sitem where sitem.fk_sales_account = sales_account.id ORDER BY sitem.id LIMIT 1)", SalesItem.class).joinFunction("JOIN sales_item_quantity on sales_item_quantity.id = (SELECT ID from sales_item_quantity siq where siq.fk_sales_item = sales_item.id ORDER BY siq.id LIMIT 1)", SalesItemQuantity.class);
        } else {
            query.selectFunc("null as fk_config_sales_location");
        }
        this.addGroupBy(query);
        return query;
    }

    private void addGroupBy(ObjectQuery query) {
        if (BaseReportGrouping.StoreId.equals((Object)this.groupBy)) {
            query.groupBy(Account.Properties.STORE_ID);
        } else if (BaseReportGrouping.TradingDay.equals((Object)this.groupBy)) {
            query.groupBy(Account.Properties.TRADING_DAY);
        } else if (BaseReportGrouping.SalesLocation.equals((Object)this.groupBy)) {
            query.groupBy(SalesItemQuantity.Properties.SALES_LOCATION);
        }
    }

    public void setGroupBy(BaseReportGrouping groupBy) {
        this.groupBy = groupBy;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }
}

