/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.patrons;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class BasePatronsByAdjustmentSearcher
extends DynamicColumnSearcher {
    private final RangeQuerySearchFilter<Date> dayFilter;
    static final String SUB_QUERY_ALIAS = "adjustments";

    public BasePatronsByAdjustmentSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery topQuery = new ObjectQuery();
        topQuery.from("(" + this.getSubQuery().toString() + ") ", SUB_QUERY_ALIAS);
        topQuery.from("finance_trading_day", null);
        topQuery.selectFunc("category_name");
        topQuery.selectFunc("adj_name");
        topQuery.selectFunc("SUM(patrons) as patrons");
        topQuery.selectFunc("SUM(saved_total) as total_sales");
        topQuery.selectFunc("SUM(total_discounts) as total_discounts");
        topQuery.selectFunc("SUM(num_of_accounts) as num_of_accounts");
        topQuery.selectFunc("FK_inventory_price_adjustment");
        topQuery.whereFunction("finance_trading_day.ID = adjustments.trading_day_id");
        topQuery.groupBy("adjustments.category_id, adjustments.FK_inventory_price_adjustment");
        return topQuery;
    }

    private ObjectQuery getSubQuery() {
        ObjectQuery subQuery = Query.select(SalesPriceAdjustment.Properties.ID, "sales_adj_id");
        subQuery.select(InventoryCategory.Properties.ID, "category_id").select(InventoryCategory.Properties.LABEL, "category_name").select(SalesPriceAdjustment.Properties.INVENTORY_PRICE_ADJUSTMENT).select(SalesPriceAdjustment.Properties.LABEL, "adj_name").select(Account.Properties.NUM_PATRONS).select(Account.Properties.SAVED_TOTAL).select(Account.Properties.ID, "account_id");
        this.addQueryForTotalDiscounts(subQuery);
        subQuery.selectFunc("COUNT(DISTINCT sales_account.ID) as num_of_accounts").select(SalesLocation.Properties.LABEL, "location").select(TradingDay.Properties.DATE, "trading_day").select(TradingDay.Properties.ID, "trading_day_id").linkUsing(SalesPriceAdjustment.Properties.TERMINAL).linkUsing(Terminal.Properties.SALES_LOCATION).linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(InventoryItem.Properties.CATEGORY);
        subQuery.groupBy("inventory_category.ID, sales_price_adjustment.ID");
        return subQuery;
    }

    private void addQueryForTotalDiscounts(ObjectQuery query) {
        query.selectFunc(" (SELECT SUM(sales_component.item_discount_total + sales_component.account_discount_total) FROM sales_component, sales_item WHERE sales_component.FK_sales_item = sales_item.ID AND sales_item.FK_sales_account = sales_account.ID) AS total_discounts");
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("category_name", "adj_name", "patrons", "total_sales", "total_discounts", "num_of_accounts", "FK_inventory_price_adjustment");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "";
    }
}

