/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.reconciliation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.AbstractReconciliationEntry;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TradingDay;
import ordermate.database.searchers.ArrayObjectSearcher;

public class BaseReconciliationSearcher
extends ArrayObjectSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;
    private static final List<String> types = new ArrayList<String>();

    public BaseReconciliationSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.select(TradingDay.Properties.DATE, "trading_day").select(SalesLocation.Properties.LABEL, "location").sum(AbstractReconciliationEntry.Properties.VALUE, "actual_total");
        query.linkUsing(CashdrawerReconciliation.Properties.CASHDRAWER).linkUsing(CashDrawer.Properties.HOST).linkUsing(Terminal.Properties.SALES_LOCATION).linkUsing(AbstractReconciliationEntry.Properties.PARENT).linkUsing(CashdrawerReconciliation.Properties.PARENT).linkUsing(ShiftReconciliation.Properties.SHIFT).linkUsing(Shift.Properties.TRADING_DAY);
        for (String nextType : types) {
            StringBuilder SB = new StringBuilder("SUM(IF(finance_reconciliation_entry.type = '");
            SB.append(nextType).append("', value, 0)) as `").append(nextType).append("`");
            query.selectFunc(SB.toString());
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> createStaticColumns() {
        if (types.isEmpty()) {
            List<String> list = types;
            synchronized (list) {
                types.addAll(AbstractReconciliationEntry.RecEntryType.register.keySet());
                Collections.sort(types);
            }
        }
        ArrayList<String> toReturn = new ArrayList<String>(Arrays.asList("trading_day", "location", "actual_total"));
        toReturn.addAll(types);
        return toReturn;
    }
}

