/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class BaseNewSalesSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseNewSalesSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total").sumMultiplication(SalesComponent.Properties.UNIT_TAX_AMOUNT, SalesItemQuantity.Properties.QUANTITY, "total_tax").selectFunc("SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) as total_ex").selectFunc("COUNT(DISTINCT " + SalesItem.Properties.ACCOUNT + ") AS account_count").select(TradingDay.Properties.DATE, "total_date").select(SalesLocation.Properties.LABEL, "location");
        query.selectFunc("SUM((sales_component.account_discount_total + sales_component.item_discount_total) * sales_item_quantity.quantity) as total_discount");
        this.appendAccountTypeQueryPart(query);
        query.linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(Account.Properties.TRADING_DAY).linkUsing(SalesItemQuantity.Properties.SALES_LOCATION);
        this.appendDynamicColumnsQueryPart(query);
        return query;
    }

    private void appendAccountTypeQueryPart(ObjectQuery query) {
        AccountType[] accountTypes;
        for (AccountType type : accountTypes = AccountType.getTypes()) {
            query.selectFunc("SUM( IF(sales_account.account_type = '" + type.toString() + "', (sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity, 0)) as " + type.toString() + "_total_ex");
            query.selectFunc("SUM( IF(sales_account.account_type = '" + type.toString() + "', sales_component.unit_price * sales_item_quantity.quantity, 0)) as " + type.toString() + "_total");
            query.selectFunc("COUNT( DISTINCT IF(sales_account.account_type = '" + type.toString() + "', " + SalesItem.Properties.ACCOUNT + ", null)) as " + type.toString() + "_count");
            query.selectFunc("SUM( IF(sales_account.account_type = '" + type.toString() + "', (sales_component.account_discount_total + sales_component.item_discount_total) * sales_item_quantity.quantity, 0)) as " + type.toString() + "_total_discount");
            query.selectFunc("SUM( IF(sales_account.account_type = '" + type.toString() + "', (sales_component.account_surcharge_total + sales_component.item_surcharge_total) * sales_item_quantity.quantity, 0)) as " + type.toString() + "_total_surcharge");
        }
    }

    private void appendDynamicColumnsQueryPart(ObjectQuery query) {
        for (Pair<Object, String> nextPair : this.getDynamicColumns()) {
            StringBuilder SB;
            if (((String)nextPair.value).endsWith("_count")) {
                SB = new StringBuilder("SUM(IF(inventory_item.fk_inventory_category = ");
                SB.append(nextPair.key).append(", sales_item_quantity.quantity, 0)) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (((String)nextPair.value).endsWith("_total")) {
                SB = new StringBuilder("ROUND(SUM(IF(inventory_item.fk_inventory_category = ");
                SB.append(nextPair.key).append(", sales_component.unit_price * sales_item_quantity.quantity, 0)), 2) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (((String)nextPair.value).endsWith("_total_ex")) {
                SB = new StringBuilder("ROUND(SUM(IF(inventory_item.fk_inventory_category = ");
                SB.append(nextPair.key).append(", (sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity, 0)), 2) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (((String)nextPair.value).endsWith("_tax")) {
                SB = new StringBuilder("ROUND(SUM(IF(inventory_item.fk_inventory_category = ");
                SB.append(nextPair.key).append(", sales_component.unit_tax * sales_item_quantity.quantity, 0)), 2) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (((String)nextPair.value).endsWith("_total_discount")) {
                SB = new StringBuilder("ROUND(SUM(IF(inventory_item.fk_inventory_category = ");
                SB.append(nextPair.key).append(", (sales_component.account_discount_total + sales_component.item_discount_total) * sales_item_quantity.quantity, 0)), 2) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (!((String)nextPair.value).endsWith("_total_surcharge")) continue;
            SB = new StringBuilder("ROUND(SUM(IF(inventory_item.fk_inventory_category = ");
            SB.append(nextPair.key).append(", (sales_component.account_surcharge_total + sales_component.item_surcharge_total)  * sales_item_quantity.quantity, 0)), 2) as `").append((String)nextPair.value).append("`");
            query.selectFunc(SB.toString());
        }
    }

    @Override
    protected List<String> createStaticColumns() {
        AccountType[] accountTypes;
        ArrayList<String> cols = new ArrayList<String>(Arrays.asList("total", "total_tax", "total_ex", "account_count", "total_date", "location", "total_discount"));
        for (AccountType type : accountTypes = AccountType.getTypes()) {
            cols.add(type.toString() + "_total");
            cols.add(type.toString() + "_total_ex");
            cols.add(type.toString() + "_count");
            cols.add(type.toString() + "_total_discount");
            cols.add(type.toString() + "_total_surcharge");
        }
        return cols;
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "SELECT ID, Name FROM inventory_category cat where cat.system_state = 'ACTIVE' ORDER BY cat.Name";
    }

    @Override
    protected void addDynamicColumn(List<Pair<Object, String>> dynaCols, Object identifier, String columnLabel) {
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + "_total"));
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + "_total_ex"));
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + "_count"));
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + "_tax"));
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + "_total_discount"));
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + "_total_surcharge"));
    }
}

