/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.sales;

import au.com.ordermate.oquery.search.QueryModifier;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.DatedReportHelper;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.sales.BaseSalesHistorySearcher;

public class BaseSalesHistoryCompiler
extends AbstractBaseReportCompiler {
    private static final String CURRENT = "Current-";
    private static final String PREVIOUS = "Previous-";
    private static final String LAST_YEAR = "LastYear-";
    private BaseSalesHistorySearcher searcher;
    private Map<Object, TotalsReport> now;
    private Map<Object, TotalsReport> previous;
    private Map<Object, TotalsReport> lastYear;
    private PropertiedObject.Property groupingProperty;
    private Map<String, PropertiedObject.Property> propertyMap = new HashMap<String, PropertiedObject.Property>();
    private List<String> columnList;

    public BaseSalesHistoryCompiler() {
        HashSet<PropertiedObject.Property<DayPart>> ex = new HashSet<PropertiedObject.Property<DayPart>>();
        ex.add(TotalsReport.Properties.ID);
        ex.add(TotalsReport.Properties.STORE_ID);
        ex.add(TotalsReport.Properties.VERSION);
        ex.add(TotalsReport.Properties.MOD_COUNT);
        ex.add(TotalsReport.Properties.DAY_PART);
        for (PropertiedObject.Property prop : TotalsReport.Properties) {
            if (ex.contains(prop)) continue;
            String modWord = StringUtils.eachWordToUpperCase(prop.getName());
            this.propertyMap.put(CURRENT + modWord, prop);
            this.propertyMap.put(PREVIOUS + modWord, prop);
            this.propertyMap.put(LAST_YEAR + modWord, prop);
        }
    }

    @Override
    public void setGrouping(BaseReportGrouping grouping) {
        super.setGrouping(grouping);
        this.groupingProperty = BaseReportGrouping.StoreId.equals((Object)grouping) ? TotalsReport.Properties.STORE_ID : (BaseReportGrouping.TradingDay.equals((Object)grouping) ? TotalsReport.Properties.TOTAL_DATE : (BaseReportGrouping.SalesLocation.equals((Object)grouping) ? TotalsReport.Properties.LOCATION : null));
    }

    @Override
    public void compile() {
        List<QueryModifier> mods = CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType);
        this.searcher = this.createSearcher();
        this.searcher.setGroupBy(this.getGrouping());
        this.searcher.setQueryMods(mods);
        this.searcher.getTradingDayFilter().setStart(this.getStartDate());
        this.searcher.getTradingDayFilter().setEnd(this.getEndDate());
        this.now = new HashMap<Object, TotalsReport>();
        this.fillMap(this.now);
        this.searcher.getTradingDayFilter().setStart(this.getPreviousStart());
        this.searcher.getTradingDayFilter().setEnd(this.getPreviousEnd());
        this.previous = new HashMap<Object, TotalsReport>();
        this.fillMap(this.previous);
        this.searcher.getTradingDayFilter().setStart(this.getLastYearStart());
        this.searcher.getTradingDayFilter().setEnd(this.getLastYearEnd());
        this.lastYear = new HashMap<Object, TotalsReport>();
        this.fillMap(this.lastYear);
    }

    @Override
    protected BaseSalesHistorySearcher createSearcher() {
        this.searcher = new BaseSalesHistorySearcher();
        this.searcher.setQueryMods(CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType));
        return this.searcher;
    }

    private void fillMap(Map<Object, TotalsReport> map) {
        List reports = this.searcher.search();
        Calendar cal = null;
        if (this.groupingProperty == TotalsReport.Properties.TOTAL_DATE && map != this.now) {
            cal = Calendar.getInstance();
        }
        for (TotalsReport report : reports) {
            map.put(this.getIdentifier(report, cal, map), report);
        }
    }

    private Object getIdentifier(TotalsReport report, Calendar cal, Map<Object, TotalsReport> map) {
        if (this.groupingProperty != null) {
            if (cal == null) {
                if (TotalsReport.Properties.LOCATION.equals(this.groupingProperty)) {
                    return report.getLocation().getID();
                }
                return report.getPropertyValue(this.groupingProperty);
            }
            Date date = (Date)report.getPropertyValue(this.groupingProperty);
            if (map == this.lastYear) {
                return DatedReportHelper.moveForwardAYear(date);
            }
            if (map == this.previous) {
                return DatedReportHelper.moveForwardAPeriod(date, this.getAdapter());
            }
        }
        return null;
    }

    @Override
    public Object getValue(Object rowId, String column) {
        if (column.startsWith(CURRENT)) {
            return this.valueOf(this.now.get(rowId), column);
        }
        if (column.startsWith(PREVIOUS)) {
            return this.valueOf(this.previous.get(rowId), column);
        }
        if (column.startsWith(LAST_YEAR)) {
            return this.valueOf(this.lastYear.get(rowId), column);
        }
        return null;
    }

    private Object valueOf(TotalsReport report, String property) {
        if (report != null) {
            return report.getPropertyValue(this.propertyMap.get(property));
        }
        return null;
    }

    @Override
    public List<String> getDirectColumns() {
        if (this.columnList == null) {
            this.columnList = this.getExtraSelects();
            this.columnList.addAll(this.propertyMap.keySet());
        }
        return this.columnList;
    }

    @Override
    public Set getRowIdentifiers() {
        HashSet<Object> set = new HashSet<Object>(this.now.keySet());
        set.addAll(this.previous.keySet());
        set.addAll(this.lastYear.keySet());
        return set;
    }

    @Override
    public BaseReport getBaseReport() {
        return BaseReport.Sales;
    }
}

