/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Date;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public class BaseSalesHistorySearcher
extends PropertySearcher<TotalsReport> {
    private IRangedQuerySearchFilter<Date> dayFilter;
    private BaseReportGrouping groupBy = BaseReportGrouping.None;

    public BaseSalesHistorySearcher() {
        super(TotalsReport.class);
        this.dayFilter = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(Account.Properties.TRADING_DAY);
        this.addSearchFilter(this.dayFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.selectFunc("MAX(sales_component.ID) as ID").sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total").sumMultiplication(SalesComponent.Properties.UNIT_TAX_AMOUNT, SalesItemQuantity.Properties.QUANTITY, "total_tax").select(SalesItemQuantity.Properties.SALES_LOCATION, "fk_config_sales_location").selectFunc("COUNT(DISTINCT " + SalesItem.Properties.ACCOUNT + ") AS count").select(TradingDay.Properties.DATE, "total_date").selectFunc("null as fk_config_day_part").selectFunc("0 as mod_count").linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(Account.Properties.TRADING_DAY);
        this.addGroupBy(query);
        return query;
    }

    private void addGroupBy(ObjectQuery query) {
        if (BaseReportGrouping.StoreId.equals((Object)this.groupBy)) {
            query.groupBy(SalesComponent.Properties.STORE_ID);
        } else if (BaseReportGrouping.TradingDay.equals((Object)this.groupBy)) {
            query.groupBy(TradingDay.Properties.DATE);
        } else if (BaseReportGrouping.SalesLocation.equals((Object)this.groupBy)) {
            query.groupBy(SalesItemQuantity.Properties.SALES_LOCATION);
        }
    }

    public void setGroupBy(BaseReportGrouping groupBy) {
        this.groupBy = groupBy;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }
}

