/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.salesbreakdown;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.QueryModifier;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.propertyaccessor.ChainPropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.Searcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.SalesByCategoryReport;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.salesbreakdown.BaseSalesBreakdownSearcherByCategory;
import ordermate.database.reports.config.salesbreakdown.BaseSalesBreakdownSearcherByDayPart;
import ordermate.database.reports.config.salesbreakdown.BaseSalesBreakdownSearcherByDayPartByCategory;

public class BaseSalesBreakdownCompiler
extends AbstractBaseReportCompiler {
    private static final String COL_DAY_PART = "Sales By Day Part - ";
    private static final String COL_CATEGORY = "Sales By Category - ";
    private static final String COL_DAY_PART_CATEGORY = "Sales By Day Part By Category - ";
    private List<String> columns;
    private PropertyAccessor groupingProperty;
    private BaseSalesBreakdownSearcherByDayPart searcherByDayPart;
    private BaseSalesBreakdownSearcherByCategory searcherByCategory;
    private BaseSalesBreakdownSearcherByDayPartByCategory searcherByDayPartByCategory;
    private Map<String, Map<Object, SalesByCategoryReport>> dayPartColumns;
    private Map<String, Map<Object, SalesByCategoryReport>> categoryColumns;
    private Map<String, Map<Object, SalesByCategoryReport>> dayPartCategoryColumns;
    private List<DayPart> dayParts = new ArrayList<DayPart>();
    private Set<InventoryCategory> categories = new HashSet<InventoryCategory>();

    public BaseSalesBreakdownCompiler() {
        this.dayParts.addAll(PersistenceManager.getObjectList(DayPart.class, Query.select(DayPart.class).orderBy(DayPart.Properties.START_TIME, true).toString()));
        this.categories.addAll(InventoryCategory.getAllCategories());
    }

    @Override
    public void compile() {
        List<QueryModifier> mods = CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType);
        this.searcherByDayPart = new BaseSalesBreakdownSearcherByDayPart(this.dayParts);
        this.searcherByDayPart.setGroupBy(this.getGrouping());
        this.searcherByDayPart.getTradingDayFilter().setStart(this.getStartDate());
        this.searcherByDayPart.getTradingDayFilter().setEnd(this.getEndDate());
        this.searcherByDayPart.setQueryMods(mods);
        this.fillDayPartColumns();
        this.searcherByCategory = new BaseSalesBreakdownSearcherByCategory();
        this.searcherByCategory.setGroupBy(this.getGrouping());
        this.searcherByCategory.getTradingDayFilter().setStart(this.getStartDate());
        this.searcherByCategory.getTradingDayFilter().setEnd(this.getEndDate());
        this.searcherByCategory.setQueryMods(mods);
        this.fillCategoryColumns();
        this.searcherByDayPartByCategory = new BaseSalesBreakdownSearcherByDayPartByCategory(this.dayParts);
        this.searcherByDayPartByCategory.setGroupBy(this.getGrouping());
        this.searcherByDayPartByCategory.getTradingDayFilter().setStart(this.getStartDate());
        this.searcherByDayPartByCategory.getTradingDayFilter().setEnd(this.getEndDate());
        this.searcherByDayPartByCategory.setQueryMods(mods);
        this.fillDayPartCategoryColumns();
    }

    private Object resolveReport(SalesByCategoryReport report) {
        return this.groupingProperty == null ? null : this.groupingProperty.resolveValue(report);
    }

    private void fillDayPartColumns() {
        List results = this.searcherByDayPart.search();
        this.dayPartColumns = new HashMap<String, Map<Object, SalesByCategoryReport>>();
        for (DayPart part : this.dayParts) {
            this.dayPartColumns.put(part.getLabel(), new HashMap());
        }
        for (SalesByCategoryReport report : results) {
            this.dayPartColumns.get(report.getDayPartLabel()).put(this.resolveIdentifier(report), report);
        }
    }

    private Object resolveIdentifier(SalesByCategoryReport report) {
        return this.groupingProperty == null ? null : this.groupingProperty.resolveValue(report);
    }

    private void fillCategoryColumns() {
        List results = this.searcherByCategory.search();
        this.categoryColumns = new HashMap<String, Map<Object, SalesByCategoryReport>>();
        for (InventoryCategory category : this.categories) {
            this.categoryColumns.put(category.getLabel(), new HashMap());
        }
        for (SalesByCategoryReport report : results) {
            this.categoryColumns.get(report.getCategory()).put(this.resolveIdentifier(report), report);
        }
    }

    private void fillDayPartCategoryColumns() {
        List results = this.searcherByDayPartByCategory.search();
        this.dayPartCategoryColumns = new HashMap<String, Map<Object, SalesByCategoryReport>>();
        for (DayPart part : this.dayParts) {
            for (InventoryCategory category : this.categories) {
                this.dayPartCategoryColumns.put(part.getLabel() + " " + category.getLabel(), new HashMap());
            }
        }
        for (SalesByCategoryReport report : results) {
            this.dayPartCategoryColumns.get(report.getDayPartLabel() + " " + report.getCategory()).put(this.resolveIdentifier(report), report);
        }
    }

    @Override
    public Object getValue(Object rowId, String column) {
        block8: {
            block9: {
                block7: {
                    if (!column.startsWith(COL_DAY_PART)) break block7;
                    for (DayPart part : this.dayParts) {
                        if (!column.endsWith(part.getLabel())) continue;
                        Map<Object, SalesByCategoryReport> map = this.dayPartColumns.get(part.getLabel());
                        for (SalesByCategoryReport report : map.values()) {
                            if (!this.compareIds(rowId, this.resolveIdentifier(report))) continue;
                            return report.getTotal();
                        }
                    }
                    break block8;
                }
                if (!column.startsWith(COL_CATEGORY)) break block9;
                for (InventoryCategory category : this.categories) {
                    if (!column.endsWith(category.getLabel())) continue;
                    Map<Object, SalesByCategoryReport> map = this.categoryColumns.get(category.getLabel());
                    for (SalesByCategoryReport report : map.values()) {
                        if (!this.compareIds(rowId, this.resolveIdentifier(report))) continue;
                        return report.getTotal();
                    }
                }
                break block8;
            }
            if (!column.startsWith(COL_DAY_PART_CATEGORY)) break block8;
            for (DayPart part : this.dayParts) {
                for (InventoryCategory category : this.categories) {
                    if (!column.endsWith(part.getLabel() + " " + category.getLabel())) continue;
                    Map<Object, SalesByCategoryReport> map = this.dayPartCategoryColumns.get(part.getLabel() + " " + category.getLabel());
                    for (SalesByCategoryReport report : map.values()) {
                        if (!this.compareIds(rowId, this.resolveIdentifier(report))) continue;
                        return report.getTotal();
                    }
                }
            }
        }
        return null;
    }

    private boolean compareIds(Object rowId, Object result) {
        if (rowId == null) {
            return result == null;
        }
        return rowId.equals(result);
    }

    @Override
    public Set getRowIdentifiers() {
        HashSet<Object> set = new HashSet<Object>();
        for (Map<Object, SalesByCategoryReport> map : this.dayPartColumns.values()) {
            set.addAll(map.keySet());
        }
        for (Map<Object, SalesByCategoryReport> map : this.categoryColumns.values()) {
            set.addAll(map.keySet());
        }
        for (Map<Object, SalesByCategoryReport> map : this.dayPartCategoryColumns.values()) {
            set.addAll(map.keySet());
        }
        return set;
    }

    @Override
    public List<String> getDirectColumns() {
        this.columns = this.getExtraSelects();
        for (DayPart part : this.dayParts) {
            this.columns.add(COL_DAY_PART + part.getLabel());
        }
        for (InventoryCategory category : this.categories) {
            this.columns.add(COL_CATEGORY + category.getLabel());
        }
        for (DayPart part : this.dayParts) {
            for (InventoryCategory category : this.categories) {
                this.columns.add(COL_DAY_PART_CATEGORY + part.getLabel() + " " + category.getLabel());
            }
        }
        return this.columns;
    }

    @Override
    public void setGrouping(BaseReportGrouping grouping) {
        super.setGrouping(grouping);
        this.groupingProperty = BaseReportGrouping.StoreId.equals((Object)grouping) ? SalesByCategoryReport.Properties.STORE_ID : (BaseReportGrouping.TradingDay.equals((Object)grouping) ? SalesByCategoryReport.Properties.DATE : (BaseReportGrouping.SalesLocation.equals((Object)grouping) ? new ChainPropertyAccessor(SalesByCategoryReport.Properties.LOCATION, SalesLocation.Properties.ID) : null));
    }

    @Override
    public BaseReport getBaseReport() {
        return BaseReport.SalesBreakdown;
    }

    @Override
    protected Searcher createSearcher() {
        this.searcherByDayPart = new BaseSalesBreakdownSearcherByDayPart(this.dayParts);
        this.searcherByDayPart.setQueryMods(CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType));
        return this.searcherByDayPart;
    }
}

