/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.salesbreakdown;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.List;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.SalesByCategoryReport;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public class BaseSalesBreakdownSearcherByDayPart
extends PropertySearcher<SalesByCategoryReport> {
    private IRangedQuerySearchFilter<Date> dayFilter;
    private BaseReportGrouping groupBy = BaseReportGrouping.None;
    private List<DayPart> dayParts;

    public BaseSalesBreakdownSearcherByDayPart(List<DayPart> parts) {
        super(SalesByCategoryReport.class);
        this.dayFilter = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(Account.Properties.TRADING_DAY);
        this.addSearchFilter(this.dayFilter);
        this.dayParts = parts;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(Account.Properties.CREATION_DATE_TIME, "date").selectFunc(this.selectDayPart()).sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total").select(InventoryCategory.Properties.LABEL, "category").select(SalesItemQuantity.Properties.SALES_LOCATION, "fk_config_sales_location").selectFunc("0 as mod_count").linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).linkUsing(SalesComponent.Properties.INVENTORY_ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItem.Properties.CATEGORY, InventoryCategory.Properties.ID).linkUsing(TradingDay.Properties.ID, Account.Properties.TRADING_DAY);
        this.addGroupBy(query);
        query.groupBy("day_part_label");
        return query;
    }

    private void addGroupBy(ObjectQuery query) {
        if (BaseReportGrouping.StoreId.equals((Object)this.groupBy)) {
            query.groupBy(SalesComponent.Properties.STORE_ID);
        } else if (BaseReportGrouping.TradingDay.equals((Object)this.groupBy)) {
            query.groupBy(TradingDay.Properties.DATE);
        } else if (BaseReportGrouping.SalesLocation.equals((Object)this.groupBy)) {
            query.groupBy(SalesItemQuantity.Properties.SALES_LOCATION);
        }
    }

    public void setGroupBy(BaseReportGrouping groupBy) {
        this.groupBy = groupBy;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    private String selectDayPart() {
        if (this.dayParts.isEmpty()) {
            return "null as 'day_part_label'";
        }
        StringBuilder sb = new StringBuilder();
        for (DayPart part : this.dayParts) {
            sb.append("IF(TIME(sales_account.creation_time) >= TIME('").append(DateTimeUtils.getSQLTimeFormat().format(part.getStartTime())).append("'), '").append(part.getLabel()).append("',\n\t");
        }
        sb.append("'").append(this.dayParts.get(0).getLabel()).append("'");
        for (DayPart part : this.dayParts) {
            sb.append(")");
        }
        sb.append("as 'day_part_label'");
        return sb.toString();
    }
}

