/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.takings;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;

public class BaseTakingsSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseTakingsSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.sum(FinanceTransaction.Properties.PAID, "total_paid");
        query.select(SalesLocation.Properties.LABEL, "location").select(TradingDay.Properties.DATE, "trading_day").selectFunc("SUM(IF(finance_unit.unit_type = 'CASH', amount_paid, 0)) as total_CASH").selectFunc("SUM(IF(finance_unit.unit_type = 'CREDIT', amount_paid, 0)) as total_CREDIT").selectFunc("SUM(IF(finance_unit.unit_type = 'DEBIT', amount_paid, 0)) as total_DEBIT").selectFunc("SUM(IF(finance_unit.unit_type = 'WEB', amount_paid, 0)) as total_WEB").sum(FinanceTransaction.Properties.TIP, "tips").sum(FinanceTransaction.Properties.CASH_OUT, "cashout");
        query.linkUsing(FinanceTransaction.Properties.SALES_LOCATION).linkUsing(FinanceTransaction.Properties.TRADING_DAY).linkUsing(FinanceTransaction.Properties.SUB_TYPE).active(FinanceTransaction.class);
        for (Pair<Object, String> nextPair : this.getDynamicColumns()) {
            StringBuilder SB;
            if (((String)nextPair.value).endsWith("_count")) {
                SB = new StringBuilder("SUM(IF(finance_unit.id = ");
                SB.append(nextPair.key).append(", 1, 0)) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (!((String)nextPair.value).endsWith("_total")) continue;
            SB = new StringBuilder("ROUND(SUM(IF(finance_unit.id = ");
            SB.append(nextPair.key).append(", amount_paid, 0)), 2) as `").append((String)nextPair.value).append("`");
            query.selectFunc(SB.toString());
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("total_paid", "location", "trading_day", "total_CASH", "total_CREDIT", "total_DEBIT", "total_WEB", "tips", "cashout");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "SELECT ID, Name FROM finance_unit unit where unit.system_state = 'ACTIVE' ORDER BY unit.unit_type, unit.Name";
    }
}

