/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.voucher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.searchers.ArrayObjectSearcher;

public class BaseVoucherSearcher
extends ArrayObjectSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseVoucherSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        String sumClause = "IF(finance_gift_voucher_transaction.amount < 0 AND finance_gift_voucher_transaction.fk_finance_gift_voucher_transaction IS ";
        String sumCondition = "finance_gift_voucher_transaction.amount, 0)) AS";
        ObjectQuery query = Query.selectFunc("SUM(" + sumClause.replace("<", ">") + "NULL, " + sumCondition + " 'total_topup'").selectFunc("SUM(" + sumClause + "NOT NULL, " + sumCondition + " 'total_topup_reversal'").selectFunc("SUM(" + sumClause + "NULL, " + sumCondition + " 'total_redeemed'").selectFunc("SUM(" + sumClause.replace("<", ">") + "NOT NULL, " + sumCondition + " 'total_redeem_reversal'");
        query.select(SalesLocation.Properties.LABEL, "location").select(TradingDay.Properties.DATE, "trading_day");
        query.linkUsing(GiftVoucherTransaction.Properties.SALES_LOCATION).linkUsing(GiftVoucherTransaction.Properties.GIFT_VOUCHER).linkUsing(GiftVoucherTransaction.Properties.TRADING_DAY).active(GiftVoucherTransaction.class);
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("total_topup", "total_topup_reversal", "total_redeemed", "total_redeem_reversal", "location", "trading_day");
    }
}

