/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.reports.contest.compiler.ContestAggregateReportCompiler;
import ordermate.reports.dynamicjasper.ReportBuilder;

abstract class AbstractContestReportBuilder
extends ReportBuilder {
    final ContestAggregateReportCompiler reportCompiler;

    AbstractContestReportBuilder(ContestAggregateReportCompiler compiler) {
        this.reportCompiler = compiler;
        this.setReportFormat(ReportBuilder.TemplateFormat.A4Landscape);
        this.getReportBuilder().setPageSizeAndOrientation(Page.Page_A4_Landscape());
        this.getStyles().getColumnHeaderStyle().getFont().setFontSize(8);
        this.getStyles().getColumnHeaderStyle().setRotation(Rotation.RIGHT);
        this.getReportBuilder().setHeaderHeight(50);
        this.getReportBuilder().setPrintBackgroundOnOddRows(false);
        this.setUseGrandTotal(true);
    }

    public void initReport() {
        ArrayList<SimpleColumn> columnsToSum = new ArrayList<SimpleColumn>();
        for (String name : this.getColumnNames()) {
            ColumnProperty prop;
            SimpleColumn column = new SimpleColumn();
            if (this.isGroupingColumn(name)) {
                prop = new ColumnProperty(name, String.class);
                column.getStyle().setHorizontalAlign(HorizontalAlign.LEFT);
            } else {
                prop = new ColumnProperty(name, BigDecimal.class);
                column.getStyle().setHorizontalAlign(HorizontalAlign.RIGHT);
            }
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name);
            column.getStyle().getFont().setFontSize(8);
            column.setHeaderStyle(this.getStyles().getColumnHeaderStyle());
            this.getReportBuilder().addColumn((AbstractColumn)column);
            this.getReportBuilder().setUseFullPageWidth(true);
            if (this.isGroupingColumn(name)) continue;
            columnsToSum.add(column);
        }
        SimpleColumn jasperCol = (SimpleColumn)this.getReportBuilder().getColumn(0);
        if (jasperCol != null) {
            this.addGroups(jasperCol, columnsToSum);
        }
    }

    private boolean isGroupingColumn(String name) {
        return name.equalsIgnoreCase("Staff") || name.equalsIgnoreCase("Day Part");
    }

    abstract void addGroups(SimpleColumn var1, List<SimpleColumn> var2);

    List<String> getColumnNames() {
        return this.reportCompiler.getColumnNames();
    }
}

