/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.contest.ContestAggregateReportBuilder;
import ordermate.database.reports.contest.ContestDayPartSummaryReportBuilder;
import ordermate.database.reports.contest.compiler.ContestAggregateReportCompiler;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class ContestAggregateReportProvider
extends AbstractReportProvider {
    private static final String CONTEST_DATA_COLUMNS = "CONTEST_DATA_COLUMNS";
    private static final String CONTEST_DAY_PART_SUM = "CONTEST_DAY_PART_SUM";
    private final String REPORT_TITLE = "Contest Reports for ";
    private final String DAY_PART_SUMMARY_REPORT_TITLE = "Day Part Summary";
    private final ContestAggregateReportCompiler compiler;

    public ContestAggregateReportProvider(ContestAggregateReportCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanArrayDataSource(new Object[]{"NoData"});
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Contest Reports for " + this.compiler.getContest());
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendSubTitleAndValue(SB, "For", this.compiler.getPeriod().formatDateForDisplay(new Date()));
        builder.setSubtitle(SB.toString());
        try {
            this.addMainContestReport(builder);
            if (this.compiler.isGroupedByDayPart()) {
                this.addDayPartSummaryReport(builder);
            }
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.warn("Cannot build contest sub reports", (Throwable)ex);
        }
        return builder;
    }

    private void addMainContestReport(ReportBuilder builder) throws DJBuilderException {
        this.compiler.compileReport();
        this.addParam(CONTEST_DATA_COLUMNS, new JRTableModelDataSource(this.compiler.getData()));
        builder.getReportBuilder().addConcatenatedReport(this.generateMainReport(), (LayoutManager)new ClassicLayoutManager(), CONTEST_DATA_COLUMNS, 0, 10, false);
    }

    private void addDayPartSummaryReport(ReportBuilder builder) throws DJBuilderException {
        this.addParam(CONTEST_DAY_PART_SUM, new JRTableModelDataSource(this.compiler.getDayPartSummaryModel()));
        builder.getReportBuilder().addConcatenatedReport(this.generateDayPartSummaryReport(), (LayoutManager)new ClassicLayoutManager(), CONTEST_DAY_PART_SUM, 0, 10, false);
    }

    private DynamicReport generateMainReport() {
        ContestAggregateReportBuilder contestAggregateReportBuilder = new ContestAggregateReportBuilder(this.compiler);
        contestAggregateReportBuilder.initReport();
        return contestAggregateReportBuilder.buildJasperReport();
    }

    private DynamicReport generateDayPartSummaryReport() {
        ContestDayPartSummaryReportBuilder dayPartSumReportBuilder = new ContestDayPartSummaryReportBuilder(this.compiler);
        dayPartSumReportBuilder.setTitle("Day Part Summary");
        dayPartSumReportBuilder.initReport();
        return dayPartSumReportBuilder.buildJasperReport();
    }

    @Override
    protected String getAdditionalFooterText() {
        return "C: Category, S: Section, I: Item, CO: Combo, OG: OptionGroup, O: Option, PG: PlusGroup, P: Plus";
    }
}

