/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest;

import au.com.ordermate.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.contest.compiler.ContestAggregateReportCompiler;
import ordermate.database.users.User;
import org.apache.commons.collections.keyvalue.MultiKey;

public enum ContestReportHelper {
    INSTANCE;


    public List<String> getReportDataPerUser(ContestAggregateReportCompiler contestCompiler, User user) {
        Map<Object, List<Object>> resultMap = contestCompiler.getResultMap();
        if (resultMap == null || resultMap.keySet().isEmpty()) {
            return Collections.singletonList("There are no results for the current contest " + HtmlUtils.boldColor("'" + contestCompiler.getContest().getName() + "'", "green"));
        }
        List<String> columnNames = contestCompiler.getColumnNames();
        ArrayList<String> currentUserList = new ArrayList<String>();
        ArrayList<String> otherUsersList = new ArrayList<String>();
        for (Object row : resultMap.keySet()) {
            if (this.isCurrentUser(row, user)) {
                currentUserList.addAll(this.getContestEntities(row, resultMap.get(row), columnNames));
                continue;
            }
            otherUsersList.addAll(this.getContestEntities(row, resultMap.get(row), columnNames));
        }
        currentUserList.addAll(otherUsersList);
        return currentUserList;
    }

    private List<String> getContestEntities(Object row, List<Object> resultRow, List<String> columnNames) {
        if (resultRow.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> contestEntityList = new ArrayList<String>();
        String[][] table = new String[resultRow.size() - 1][2];
        int tableInd = 0;
        for (int rowIndex = 1; rowIndex < resultRow.size(); ++rowIndex) {
            table[tableInd][0] = HtmlUtils.highlight(columnNames.get(rowIndex + 1), "black", true, false, 3);
            table[tableInd][1] = resultRow.get(rowIndex).toString();
            ++tableInd;
        }
        contestEntityList.add(HtmlUtils.highlight(((MultiKey)row).getKey(1).toString(), "green", true, false, 3));
        contestEntityList.add(HtmlUtils.table(table, false, false));
        return contestEntityList;
    }

    private boolean isCurrentUser(Object row, User user) {
        MultiKey key = (MultiKey)row;
        Long userId = (Long)key.getKey(0);
        return user.getID().equals(userId);
    }
}

