/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest.compiler;

import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import ordermate.database.contest.Contest;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.reports.config.ArrayObjectReportCompiler;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.contest.ContestReportParams;
import ordermate.database.searchers.ArrayObjectSearcher;

public abstract class BaseContestReportCompiler<T extends ArrayObjectSearcher>
extends ArrayObjectReportCompiler<T> {
    private final ContestReportParams params;
    private final CustomReportQueryPart userIDQueryPart;
    private final CustomReportQueryPart userNameQueryPart;
    private CustomReportQueryPart dayPartQuery;

    public BaseContestReportCompiler(ContestReportParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Contest Report Compiler should have search params!");
        }
        this.params = params;
        this.setPeriod(params.getPeriod());
        this.userIDQueryPart = this.getUserIDQueryPart();
        this.userNameQueryPart = this.getUserNameQueryPart();
        this.initDayPartQuery();
    }

    private void initDayPartQuery() {
        if (this.params.isGroupedByDayPart()) {
            this.dayPartQuery = this.getDayPartQuery();
            if (this.dayPartQuery == null) {
                throw new IllegalStateException("There is no any day part defined in the system, so you cannot use this compiler by grouping daypart!");
            }
        }
    }

    @Override
    public void compile() {
        if (!this.params.isGroupedByDayPart()) {
            this.applyQueryPart(Arrays.asList(this.userIDQueryPart, this.userNameQueryPart));
        } else {
            this.applyQueryPart(Arrays.asList(this.userIDQueryPart, this.userNameQueryPart, this.dayPartQuery));
        }
        super.compile();
    }

    public Contest getContest() {
        return this.params != null ? this.params.getContest() : null;
    }

    protected CustomReportQueryPart getDayPartQuery() {
        String dayPartQueryText = this.getSelectDayPartQuery();
        if (!StringUtils.isEmpty(dayPartQueryText)) {
            CustomReportQueryPart queryPart = new CustomReportQueryPart(null, QueryPart.GROUP, this.getBaseReport(), "day_part", this.getSelectDayPartQuery());
            queryPart.setExtra("Separate");
            return queryPart;
        }
        return null;
    }

    protected CustomReportQueryPart getUserNameQueryPart() {
        CustomReportQueryPart userQueryPart = new CustomReportQueryPart(null, QueryPart.GROUP, this.getBaseReport(), "username", " CONCAT(config_user.FirstName, ' ', config_user.Surname) as username");
        userQueryPart.setExtra("Separate");
        return userQueryPart;
    }

    protected CustomReportQueryPart getUserIDQueryPart() {
        return new CustomReportQueryPart(null, QueryPart.GROUP, this.getBaseReport(), "id", "config_user");
    }

    protected abstract List<String> getDisplayableColumns();

    protected String getSelectDayPartQuery() {
        return DayPartHelper.INSTANCE.getSelectDayPartQuery(this.getTimeParamOfDayPart());
    }

    protected String getTimeParamOfDayPart() {
        return "sales_item_quantity.creation_time";
    }
}

