/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest.compiler;

import au.com.ordermate.persistence.ArrayObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;
import ordermate.database.contest.Contest;
import ordermate.database.reports.contest.ContestMultiKeyComparator;
import ordermate.database.reports.contest.ContestMultiKeyIndex;
import ordermate.database.reports.contest.ContestReportParams;
import ordermate.database.reports.contest.compiler.BaseContestReportCompiler;
import ordermate.database.reports.contest.compiler.ContestCategoryReportCompiler;
import ordermate.database.reports.contest.compiler.ContestComboReportCompiler;
import ordermate.database.reports.contest.compiler.ContestItemReportCompiler;
import ordermate.database.reports.contest.compiler.ContestOptionGroupCompiler;
import ordermate.database.reports.contest.compiler.ContestOptionReportCompiler;
import ordermate.database.reports.contest.compiler.ContestPatronsCompiler;
import ordermate.database.reports.contest.compiler.ContestPlusGroupReportCompiler;
import ordermate.database.reports.contest.compiler.ContestPlusReportCompiler;
import ordermate.database.reports.contest.compiler.ContestSectionReportCompiler;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.impl.GenericBiListTableModel;
import org.apache.commons.collections.keyvalue.MultiKey;

public class ContestAggregateReportCompiler {
    private GenericBiListTableModel<Object> tableModel;
    private List<String> columnNames;
    private Map<Object, List<Object>> resultMap;
    private final ContestReportParams params;
    private List rowIdentifiers;
    private final int COLUMN_INDEX_USER = 0;
    public static final String MSG_UNCOMPILED_REPORT_TO_GET_DATA = "You must compile report before getting its data!";
    public static final String MSG_REPORT_UNGROUPED_BY_DAY_PART = "The compiler should be grouped by day part to use this data!";

    public ContestAggregateReportCompiler(ContestReportParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Contest Report Compiler should have search params!");
        }
        this.params = params;
        this.columnNames = new ArrayList<String>();
        this.resultMap = new HashMap<Object, List<Object>>();
        this.rowIdentifiers = new ArrayList();
    }

    public Contest getContest() {
        return this.params.getContest();
    }

    public PeriodReportAdapter getPeriod() {
        return this.params.getPeriod();
    }

    public void compileReport() {
        ArrayList<BaseContestReportCompiler> compilers = new ArrayList<BaseContestReportCompiler>();
        compilers.add(new ContestPatronsCompiler(this.params));
        compilers.add(new ContestCategoryReportCompiler(this.params));
        compilers.add(new ContestSectionReportCompiler(this.params));
        compilers.add(new ContestItemReportCompiler(this.params));
        compilers.add(new ContestComboReportCompiler(this.params));
        compilers.add(new ContestPlusGroupReportCompiler(this.params));
        compilers.add(new ContestPlusReportCompiler(this.params));
        compilers.add(new ContestOptionGroupCompiler(this.params));
        compilers.add(new ContestOptionReportCompiler(this.params));
        this.runCompilers(compilers);
        this.tableModel = this.createTableModel(compilers);
    }

    private GenericBiListTableModel<Object> createTableModel(List<BaseContestReportCompiler> compilers) {
        LinkedHashSet<String> dynamicColumnNames = new LinkedHashSet<String>();
        HashSet rowIdentifiers = new HashSet();
        for (BaseContestReportCompiler compiler : compilers) {
            List<String> displayableColumns = compiler.getDisplayableColumns();
            if (displayableColumns != null && !displayableColumns.isEmpty()) {
                dynamicColumnNames.addAll(displayableColumns);
            }
            rowIdentifiers.addAll(compiler.getRowIdentifiers());
        }
        this.rowIdentifiers = new ArrayList(rowIdentifiers);
        Collections.sort(this.rowIdentifiers, new ContestMultiKeyComparator(ContestMultiKeyIndex.User.getValue()));
        this.resultMap = this.getResultMap(compilers, this.rowIdentifiers);
        this.columnNames = this.getFinalColumnNames(dynamicColumnNames);
        this.tableModel = new GenericBiListTableModel(this.columnNames, this.getFinalReportData(this.resultMap, this.rowIdentifiers));
        return this.tableModel;
    }

    public Map<Object, List<Object>> getResultMap() {
        return Collections.unmodifiableMap(this.resultMap);
    }

    private List<String> getFinalColumnNames(Set<String> dynamicColumnNames) {
        ArrayList<String> finalColumnNames = new ArrayList<String>();
        finalColumnNames.add("Staff");
        if (this.params.isGroupedByDayPart()) {
            finalColumnNames.add("Day Part");
        }
        finalColumnNames.addAll(dynamicColumnNames);
        finalColumnNames.add("Total");
        return finalColumnNames;
    }

    private List<List<Object>> getFinalReportData(Map<Object, List<Object>> resultMap, List sortedRow) {
        ArrayList<List<Object>> finalReportData = new ArrayList<List<Object>>();
        for (Object nextId : sortedRow) {
            MultiKey key = (MultiKey)nextId;
            ArrayList<String> reportData = new ArrayList<String>();
            reportData.add(key.getKey(ContestMultiKeyIndex.User.getValue()).toString());
            if (this.params.isGroupedByDayPart()) {
                reportData.add(this.getDayPartWithoutIndex(key));
            }
            reportData.addAll((Collection)resultMap.get(nextId));
            finalReportData.add(reportData);
        }
        return finalReportData;
    }

    private Map<Object, List<Object>> getResultMap(List<BaseContestReportCompiler> compilers, List sortedRow) {
        HashMap<Object, List<Object>> resultMap = new HashMap<Object, List<Object>>();
        HashMap<Object, BigDecimal> totalMap = new HashMap<Object, BigDecimal>();
        for (BaseContestReportCompiler compiler : compilers) {
            if (compiler.getDisplayableColumns().isEmpty()) continue;
            for (Object rowId : sortedRow) {
                ArrayObject arrayObj;
                ArrayList<BigDecimal> resultObjects = (ArrayList<BigDecimal>)resultMap.get(rowId);
                if (resultObjects == null) {
                    resultObjects = new ArrayList<BigDecimal>();
                }
                if ((arrayObj = compiler.getArrayObject(rowId)) != null) {
                    resultObjects.addAll(this.getActualObjects(compiler, rowId, totalMap));
                } else {
                    resultObjects.addAll(this.getEmptyObjects(compiler.getDisplayableColumns()));
                }
                resultMap.put(rowId, resultObjects);
            }
        }
        for (BaseContestReportCompiler<Object> row : resultMap.keySet()) {
            BigDecimal totalValue = (BigDecimal)totalMap.get(row);
            ((List)resultMap.get(row)).add(totalValue != null ? totalValue : BigDecimal.ZERO.setScale(0));
        }
        return resultMap;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    private List<BigDecimal> getEmptyObjects(List<String> displayableColumns) {
        ArrayList<BigDecimal> emptyObjects = new ArrayList<BigDecimal>();
        for (String column : displayableColumns) {
            emptyObjects.add(BigDecimal.ZERO);
        }
        return emptyObjects;
    }

    private List<BigDecimal> getActualObjects(BaseContestReportCompiler compiler, Object rowId, Map<Object, BigDecimal> totalMap) {
        ArrayList<BigDecimal> actualObjects = new ArrayList<BigDecimal>();
        List<String> displayableColumns = compiler.getDisplayableColumns();
        for (String directColumn : displayableColumns) {
            actualObjects.add(this.getRowValue(compiler.getValue(rowId, directColumn)));
            if ("Patrons".equalsIgnoreCase(directColumn)) continue;
            BigDecimal total = totalMap.get(rowId);
            if (total != null) {
                totalMap.put(rowId, totalMap.get(rowId).add(this.getRowValue(compiler.getValue(rowId, directColumn))));
                continue;
            }
            totalMap.put(rowId, this.getRowValue(compiler.getValue(rowId, directColumn)));
        }
        return actualObjects;
    }

    private BigDecimal getRowValue(Object value) {
        if (value == null) {
            return BigDecimal.ZERO.setScale(0);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value).setScale(0);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(0);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue()).setScale(0);
        }
        throw new IllegalArgumentException("The type of value should be number(double, big decimal), however got " + value);
    }

    private void runCompilers(Collection<BaseContestReportCompiler> compilers) {
        for (BaseContestReportCompiler compiler : compilers) {
            compiler.compile();
        }
    }

    public TableModel getData() {
        this.validateReportCompiled();
        return this.tableModel;
    }

    private void validateReportCompiled() {
        if (this.tableModel == null) {
            throw new IllegalStateException(MSG_UNCOMPILED_REPORT_TO_GET_DATA);
        }
    }

    private void validateReportGroupedByDayPart() {
        if (!this.isGroupedByDayPart()) {
            throw new IllegalStateException(MSG_REPORT_UNGROUPED_BY_DAY_PART);
        }
    }

    public TableModel getDayPartSummaryModel() {
        this.validateReportCompiled();
        this.validateReportGroupedByDayPart();
        Map<Object, List<Object>> resultMap = this.getResultMap();
        LinkedHashMap<String, List<Object>> mapByDayPart = new LinkedHashMap<String, List<Object>>();
        for (Object nextId : this.getSortedKeysByDayPart()) {
            MultiKey key = (MultiKey)nextId;
            String dayPart = this.getDayPartWithoutIndex(key);
            if (!mapByDayPart.containsKey(dayPart)) {
                mapByDayPart.put(dayPart, resultMap.get(nextId));
                continue;
            }
            List existentColumnValues = (List)mapByDayPart.get(dayPart);
            List<Object> incomingColumnValues = resultMap.get(nextId);
            ArrayList<BigDecimal> newColumnValues = new ArrayList<BigDecimal>();
            for (int ind = 0; ind < existentColumnValues.size(); ++ind) {
                newColumnValues.add(this.getRowValue(existentColumnValues.get(ind)).add(this.getRowValue(incomingColumnValues.get(ind))));
            }
            mapByDayPart.put(dayPart, newColumnValues);
        }
        return new GenericBiListTableModel(this.getColumnNamesWithoutUser(), this.getDayPartReportData(mapByDayPart));
    }

    public List<String> getColumnNamesWithoutUser() {
        ArrayList<String> columnNamesByDayPart = new ArrayList<String>(this.columnNames);
        columnNamesByDayPart.remove(0);
        return Collections.unmodifiableList(columnNamesByDayPart);
    }

    private List<List<Object>> getDayPartReportData(Map<String, List<Object>> mapByDayPart) {
        ArrayList<List<Object>> dayPartSpecificReportData = new ArrayList<List<Object>>();
        for (String keyValue : mapByDayPart.keySet()) {
            ArrayList<String> dayPartRow = new ArrayList<String>();
            dayPartRow.add(keyValue);
            dayPartRow.addAll((Collection)mapByDayPart.get(keyValue));
            dayPartSpecificReportData.add(dayPartRow);
        }
        return dayPartSpecificReportData;
    }

    private String getDayPartWithoutIndex(MultiKey key) {
        String dayPart = key.getKey(ContestMultiKeyIndex.DayPart.getValue()).toString();
        dayPart = dayPart.substring(dayPart.lastIndexOf(".") + 1);
        return dayPart;
    }

    private List getSortedKeysByDayPart() {
        ArrayList newKeyList = new ArrayList(this.rowIdentifiers);
        Collections.sort(newKeyList, new ContestMultiKeyComparator(ContestMultiKeyIndex.DayPart.getValue()));
        return newKeyList;
    }

    public void setContest(Contest contest) {
        this.params.setContest(contest);
    }

    public boolean isGroupedByDayPart() {
        return this.params.isGroupedByDayPart();
    }
}

