/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest.searcher;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.contest.Contest;
import ordermate.database.contest.ContestEntity;
import ordermate.database.contest.ContestEntityType;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.contest.ContestQueries;
import ordermate.database.searchers.ArrayObjectSearcher;

public abstract class BaseContestReportSearcher
extends ArrayObjectSearcher {
    private List<Pair<Long, String>> dynamicColumns;
    private List<String> dynamicColumnNames;
    private RangeQuerySearchFilter<Date> dayFilter;
    private Contest contest;

    public BaseContestReportSearcher(Contest contest) {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
        this.contest = contest;
        this.dynamicColumns = new ArrayList<Pair<Long, String>>();
        this.dynamicColumnNames = new ArrayList<String>();
        this.createDynamicColumns();
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    public List<Pair<Long, String>> getDynamicColumns() {
        return Collections.unmodifiableList(this.dynamicColumns);
    }

    public List<String> getDisplayableColumns() {
        return Collections.unmodifiableList(this.dynamicColumnNames);
    }

    protected void createDynamicColumns() {
        List<ContestEntity> entities = PersistenceManager.getObjectList(ContestEntity.class, ContestQueries.getContestEntities(this.contest, this.getEntityType()).toString());
        for (ContestEntity entity : entities) {
            String contestEntityLabel = this.getContestEntityLabel(entity.getEntityId(), entity.getEntityType());
            this.dynamicColumns.add(new Pair<Long, String>(entity.getEntityId(), contestEntityLabel));
            this.dynamicColumnNames.add(contestEntityLabel);
            this.columns.add(contestEntityLabel);
        }
    }

    protected Object getContestEntityBO(Long entityID, ContestEntityType entityType) {
        return PersistenceManager.getByID(entityID, entityType.getClazz());
    }

    protected String getContestEntityLabel(Long entityID, ContestEntityType entityType) {
        Object entityObj = this.getContestEntityBO(entityID, entityType);
        StringBuilder sb = new StringBuilder(entityObj.toString());
        sb.append("(").append(entityType.getShortName()).append(")");
        return sb.toString();
    }

    protected Contest getContest() {
        return this.contest;
    }

    protected ContestEntityType getEntityType() {
        return ContestEntityType.ItemUnit;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Collections.singletonList("User");
    }
}

