/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest.searcher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.util.Pair;
import ordermate.database.contest.Contest;
import ordermate.database.contest.ContestEntityType;
import ordermate.database.reports.contest.searcher.BaseContestReportSearcher;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItemQuantity;

public class ContestComboReportSearcher
extends BaseContestReportSearcher {
    public ContestComboReportSearcher(Contest contest) {
        super(contest);
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.selectFunc(" CONCAT(config_user.FirstName, ' ', config_user.Surname) AS User");
        query.linkUsing(SalesItemQuantity.Properties.SALES_LOCATION).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesCombo.Properties.SAVED_QUANTITIES).not().isNull(SalesCombo.Properties.COMBO);
        for (Pair<Long, String> entityObjectPair : this.getDynamicColumns()) {
            StringBuilder sb = new StringBuilder("ROUND(SUM(IF(sales_item.FK_inventory_combo = ");
            sb.append(entityObjectPair.key).append(", sales_item_quantity.quantity, 0)),2) as `").append((String)entityObjectPair.value).append("`");
            query.selectFunc(sb.toString());
        }
        return query;
    }

    @Override
    protected ContestEntityType getEntityType() {
        return ContestEntityType.Combo;
    }
}

