/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest.searcher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.util.Pair;
import ordermate.database.contest.Contest;
import ordermate.database.contest.ContestEntityType;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.reports.contest.searcher.BaseContestReportSearcher;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesOption;

public class ContestOptionGroupReportSearcher
extends BaseContestReportSearcher {
    public ContestOptionGroupReportSearcher(Contest contest) {
        super(contest);
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.selectFunc(" CONCAT(config_user.FirstName, ' ', config_user.Surname) AS User");
        query.linkUsing(SalesItemQuantity.Properties.SALES_LOCATION).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesOption.Properties.COMPONENT).linkUsing(SalesOption.Properties.OPTION, InventoryOption.Properties.ID);
        for (Pair<Long, String> entityObjectPair : this.getDynamicColumns()) {
            StringBuilder sb = new StringBuilder("ROUND(SUM(IF(inventory_option.FK_inventory_option_group = ");
            sb.append(entityObjectPair.key).append(", sales_item_quantity.quantity, 0)),2) as `").append((String)entityObjectPair.value).append("`");
            query.selectFunc(sb.toString());
        }
        return query;
    }

    @Override
    protected ContestEntityType getEntityType() {
        return ContestEntityType.OptionGroup;
    }
}

