/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.contest.searcher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;

public class ContestPatronsSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public ContestPatronsSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.selectFunc(" CONCAT(config_user.FirstName, ' ', config_user.Surname) as User").sum(Account.Properties.NUM_PATRONS, "Patrons");
        query.linkUsing(Account.Properties.TRADING_DAY).linkUsing(Account.Properties.ASSIGNED_USER).wherePropertyIn(Account.Properties.ACCOUNT_TYPE, new AccountType[]{AccountType.tableType, AccountType.onlineTableType});
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("User", "Patrons");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "";
    }

    public List<String> getDisplayableColumns() {
        return Collections.singletonList("Patrons");
    }
}

