/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.coupon;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.inventory.coupon.InventoryCoupon;

@Entity
public class CouponReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<InventoryCoupon> coupon;
    private Long numIssued;
    private BigDecimal numExpired;
    private BigDecimal numActivated;
    private BigDecimal numUsed;
    private BigDecimal numRedemptions;
    private BigDecimal avgRedemptionDays;
    private BigDecimal avgActivationDays;
    private String group;

    public CouponReport() {
        this.coupon = this.createReference(CouponReport.Properties.COUPON);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_coupon")
    public InventoryCoupon getCoupon() {
        return this.coupon.get();
    }

    @Column(name="num_issued")
    public Long getNumIssued() {
        return this.numIssued;
    }

    @Column(name="num_expired")
    public BigDecimal getNumExpired() {
        return this.numExpired;
    }

    @Column(name="num_activated")
    public BigDecimal getNumActivated() {
        return this.numActivated;
    }

    @Column(name="num_redemptions")
    public BigDecimal getNumRedemptions() {
        return this.numRedemptions;
    }

    @Column(name="avg_redemption_days")
    public BigDecimal getAvgRedemptionDays() {
        return this.avgRedemptionDays;
    }

    @Column(name="avg_activation_days")
    public BigDecimal getAvgActivationDays() {
        return this.avgActivationDays;
    }

    @Column(name="num_used")
    public BigDecimal getNumUsed() {
        return this.numUsed;
    }

    @Column(name="group_string")
    public String getGroup() {
        return this.group;
    }

    public void setCoupon(InventoryCoupon value) {
        this.coupon.set(value);
    }

    public void setNumIssued(Long numberIssued) {
        this.numIssued = numberIssued;
    }

    public void setNumExpired(BigDecimal value) {
        this.numExpired = value;
    }

    public void setNumActivated(BigDecimal numberActivated) {
        this.numActivated = numberActivated;
    }

    public void setNumRedemptions(BigDecimal numberRedemptions) {
        this.numRedemptions = numberRedemptions;
    }

    public void setAvgRedemptionDays(BigDecimal avgRedemptionTime) {
        this.avgRedemptionDays = avgRedemptionTime;
    }

    public void setAvgActivationDays(BigDecimal avgActivationTime) {
        this.avgActivationDays = avgActivationTime;
    }

    public void setNumUsed(BigDecimal numUsed) {
        this.numUsed = numUsed;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Transient
    public String getAvgRedemptionString() {
        int days;
        int n = days = this.getAvgRedemptionDays() == null ? -1 : this.getAvgRedemptionDays().intValue();
        if (days >= 0) {
            return days + " days";
        }
        return "N/A";
    }

    @Transient
    public String getAvgActivationString() {
        int days;
        int n = days = this.getAvgActivationDays() == null ? -1 : this.getAvgActivationDays().intValue();
        if (days >= 0) {
            return days + " days";
        }
        return "N/A";
    }

    @Transient
    public Double getUsedPerc() {
        if (this.getNumIssued() == null || this.getNumIssued().doubleValue() == 0.0) {
            return 0.0;
        }
        return this.getNumUsed().doubleValue() / this.getNumIssued().doubleValue();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<String> GROUP;
        public PropertiedObject.Property<InventoryCoupon> COUPON;
        public PropertiedObject.Property<Long> NUM_ISSUED;
        public PropertiedObject.Property<BigDecimal> NUM_EXPIRED;
        public PropertiedObject.Property<BigDecimal> NUM_ACTIVATED;
        public PropertiedObject.Property<BigDecimal> NUM_REDEMPTIONS;
        public PropertiedObject.Property<BigDecimal> AVG_REDEMPTION_DAYS;
        public PropertiedObject.Property<BigDecimal> AVG_ACTIVATION_DAYS;
        public PropertiedObject.Property<Long> NUM_USED;
        public PersistentObject.DerivedProperty<String> AVG_ACTIVATION_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CouponReport.class), "avgActivationString");
        public PersistentObject.DerivedProperty<String> AVG_REDEMPTION_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CouponReport.class), "avgRedemptionString");
        public PersistentObject.DerivedProperty<Double> USED_PERC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CouponReport.class), "usedPerc");
    }
}

