/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.coupon;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.reports.coupon.CouponReport;
import ordermate.database.sales.coupon.SalesCoupon;

public class CouponReportSearcher
extends PropertySearcher<CouponReport> {
    private DateRangeSearchFilter createdFilter;
    private ISingleValueSearchFilter<InventoryCoupon> inventoryCouponFilter;
    private DateRangeSearchFilter activatedFilter;
    private SingleValueSearchFilter<Boolean> localFilter;

    public CouponReportSearcher() {
        super(CouponReport.class);
        this.createdFilter = new OptimisedDateRangeSearchFilter(SalesCoupon.Properties.CREATED, SQLDateType.TIMESTAMP);
        this.inventoryCouponFilter = new ObjectJoinSearchFilter<InventoryCoupon>(new PropertiedObject.Property[]{SalesCoupon.Properties.INVENTORY_COUPON}, new ObjectSearchFilter<InventoryCoupon>(InventoryCoupon.Properties.PROTOTYPE_COUPON));
        this.activatedFilter = new OptimisedDateRangeSearchFilter(SalesCoupon.Properties.ACTIVATED, SQLDateType.TIMESTAMP);
        this.localFilter = new ObjectSearchFilter<Boolean>(SalesCoupon.Properties.LOCAL);
        this.addSearchFilter(this.createdFilter);
        this.addSearchFilter(this.inventoryCouponFilter);
        this.addSearchFilter(this.activatedFilter);
        this.addSearchFilter(this.localFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(SalesCoupon.Properties.ID, "ID").select(SalesCoupon.Properties.INVENTORY_COUPON, "fk_inventory_coupon").count(SalesCoupon.class, "num_issued").selectFunc("sum(IF(inventory_coupon.expires < NOW(), 1, 0)) as 'num_expired'").sum(SalesCoupon.Properties.NUM_USES, "num_redemptions").selectFunc("sum(IF(sales_coupon.activated IS NULL, 0, 1)) as 'num_activated' ").selectFunc("sum(IF(sales_coupon.first_used IS NULL, 0, 1)) as 'num_used'").selectFunc("avg(DATEDIFF(sales_coupon.activated, sales_coupon.created)) as 'avg_activation_days'").selectFunc("avg(DATEDIFF(sales_coupon.first_used, sales_coupon.created)) as 'avg_redemption_days'").selectFunc("0 as mod_count").active(SalesCoupon.class);
        PersistenceManager.getInstance();
        if (PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            query.select(SalesCoupon.Properties.STORE_ID, "store_id");
        }
        query.linkUsing(SalesCoupon.Properties.INVENTORY_COUPON).groupBy(SalesCoupon.Properties.INVENTORY_COUPON);
        query = this.addGrouping(query);
        return query;
    }

    protected ObjectQuery addGrouping(ObjectQuery query) {
        return query.select(InventoryCoupon.Properties.LABEL, "group_string").orderBy(InventoryCoupon.Properties.LABEL);
    }

    @FilterConfig(name="Created", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=1)
    public DateRangeSearchFilter getCreatedFilter() {
        return this.createdFilter;
    }

    @FilterConfig(name="Coupon", dataType=InventoryCoupon.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=1)
    public ISingleValueSearchFilter<InventoryCoupon> getInventoryCouponFilter() {
        return this.inventoryCouponFilter;
    }

    @FilterConfig(name="Activated", dataType=Date.class, dateType=SQLDateType.TIMESTAMP, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=3)
    public DateRangeSearchFilter getActivatedFilter() {
        return this.activatedFilter;
    }

    @FilterConfig(name="Local Only", dataType=Boolean.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=4)
    public SingleValueSearchFilter<Boolean> getLocalFilter() {
        return this.localFilter;
    }
}

