/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.coupon;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.inventory.coupon.InventoryCoupon;

@Entity
public class CouponUsageReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private String group;
    private Reference<InventoryCoupon> coupon;
    private Long numRedemptions;
    private BigDecimal avgRedemptionDays;

    public CouponUsageReport() {
        this.coupon = this.createReference(CouponUsageReport.Properties.COUPON);
    }

    @Column(name="group_string")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    @ManyToOne(targetEntity=InventoryCoupon.class)
    @JoinColumn(name="fk_inventory_coupon")
    public InventoryCoupon getCoupon() {
        return this.coupon.get();
    }

    protected void setCoupon(InventoryCoupon value) {
        this.coupon.set(value);
    }

    protected void setInventoryCoupon(InventoryCoupon value) {
        this.coupon.set(value);
    }

    @Column(name="num_redemptions")
    public Long getNumRedemptions() {
        return this.numRedemptions;
    }

    public void setNumRedemptions(Long value) {
        this.numRedemptions = value;
    }

    @Column(name="avg_redemption_days")
    public BigDecimal getAvgRedemptionDays() {
        return this.avgRedemptionDays;
    }

    public void setAvgRedemptionDays(BigDecimal value) {
        this.avgRedemptionDays = value;
    }

    @Transient
    public String getAvgRedemptionString() {
        return this.avgRedemptionDays == null ? "N/A" : this.avgRedemptionDays + " days";
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<String> GROUP;
        public PropertiedObject.Property<InventoryCoupon> COUPON;
        public PropertiedObject.Property<Long> NUM_REDEMPTIONS;
        public PropertiedObject.Property<BigDecimal> AVG_REDEMPTION_DAYS;
        public PersistentObject.DerivedProperty<String> AVG_REDEMPTION_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CouponUsageReport.class), "avgRedemptionString");
    }
}

