/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.coupon;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import java.util.ArrayList;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.coupon.CouponUsageReport;
import ordermate.database.reports.coupon.CouponUsageReportSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class CouponUsageReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider<CouponUsageReportSearcher> dataProvider;
    private CouponUsageReportSearcher searcher;

    public CouponUsageReportProvider(CouponUsageReportSearcher yourSearcher) {
        this.searcher = yourSearcher;
        this.dataProvider = new SearcherDataSourceProvider<CouponUsageReportSearcher>(this.searcher);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.dataProvider.getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.setTitle("Coupon Usage Report");
        String subtitle = this.makeSubtitle();
        builder.setSubtitle(subtitle);
        this.addColumns(builder);
        return builder;
    }

    protected void addColumns(ReportBuilder builder) throws ColumnBuilderException {
        builder.addReportColumn(CouponUsageReport.Properties.GROUP, null);
        builder.addReportColumn(CouponUsageReport.Properties.NUM_REDEMPTIONS, "Redemptions", null);
        builder.addReportColumn(CouponUsageReport.Properties.AVG_REDEMPTION_STRING, "Avg Redemption", null);
        builder.addGroupBy(CouponUsageReport.Properties.GROUP, new ArrayList<ReportBuilder.PropertyCalculation>());
    }

    protected CouponUsageReportSearcher getSearcher() {
        return this.searcher;
    }

    private String makeSubtitle() {
        StringBuilder SB = new StringBuilder();
        DateRangeSearchFilter usedFilter = this.searcher.getUsedFilter();
        if (usedFilter.hasSearchValue()) {
            SB.append(PeriodReportAdapter.DAILY.formatRangeForDisplay((Date)usedFilter.getStart(), (Date)usedFilter.getEnd()));
        }
        this.getHelper().appendSearchFilter(SB, "Coupon", this.searcher.getInventoryCouponFilter());
        this.getHelper().appendCollection(SB, "Sales Location", this.searcher.getSalesLocationFilter().getSelectedOptions());
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

