/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.coupon;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.reports.coupon.CouponUsageReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;

public class CouponUsageReportSearcher
extends PropertySearcher<CouponUsageReport> {
    private DateRangeSearchFilter usedFilter;
    private ISingleValueSearchFilter<InventoryCoupon> inventoryCouponFilter;
    private MultiOptionJoinSearchFilter<SalesLocation> salesLocationsFilter;

    public CouponUsageReportSearcher() {
        super(CouponUsageReport.class);
        this.usedFilter = new OptimisedDateRangeSearchFilter(SalesCouponUsage.Properties.DATE_USED, SQLDateType.TIMESTAMP);
        this.inventoryCouponFilter = new ObjectJoinSearchFilter<InventoryCoupon>(new PropertiedObject.Property[]{SalesCouponUsage.Properties.COUPON, SalesCoupon.Properties.INVENTORY_COUPON}, new ObjectSearchFilter<InventoryCoupon>(InventoryCoupon.Properties.PROTOTYPE_COUPON));
        this.salesLocationsFilter = new MultiOptionJoinSearchFilter(SalesCouponUsage.Properties.ACCOUNT, Account.Properties.SALES_LOCATION);
        this.addSearchFilter(this.usedFilter);
        this.addSearchFilter(this.inventoryCouponFilter);
        this.addSearchFilter(this.salesLocationsFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(SalesCoupon.Properties.INVENTORY_COUPON, "fk_inventory_coupon").count(SalesCouponUsage.class, "num_redemptions").selectFunc("avg(DATEDIFF(sales_coupon_usage.date_of_use, sales_coupon.created)) as 'avg_redemption_days'").linkUsing(SalesCouponUsage.Properties.COUPON).linkUsing(SalesCoupon.Properties.INVENTORY_COUPON).active(SalesCouponUsage.class).groupBy(SalesCoupon.Properties.INVENTORY_COUPON);
        query = this.addGrouping(query);
        return query;
    }

    protected ObjectQuery addGrouping(ObjectQuery query) {
        return query.select(InventoryCoupon.Properties.LABEL, "group_string").orderBy(InventoryCoupon.Properties.LABEL);
    }

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.TIMESTAMP, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public DateRangeSearchFilter getUsedFilter() {
        return this.usedFilter;
    }

    @FilterConfig(name="Coupon", defaultValue="1", dataType=InventoryCoupon.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=2)
    public ISingleValueSearchFilter<InventoryCoupon> getInventoryCouponFilter() {
        return this.inventoryCouponFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionJoinSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationsFilter;
    }
}

