/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.covers;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.CoversReport;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.searchers.reports.CoversReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class CoversReportProvider
extends AbstractReportProvider {
    private final ReportBuilder builder = new ReportBuilder();
    private final SearcherDataSourceProvider dsProvider;
    private final CoversReportSearcher coversSearcher;
    private volatile DynamicReport report = null;
    private final String[] columnTitles;
    private final PropertiedObject.Property[] columnProperties;
    private String reportTitle = Internationalization.getLiteralFor("COVERS") + " Report";
    private User user;
    public static final int DAY_INDEX = 0;
    public static final int TABLE_SECTION_INDEX = 1;
    public static final int COVERS_INDEX = 2;
    public static final int TOTAL_SALES_INDEX = 3;
    public static final int DOLLARS_PER_HEAD_INDEX = 4;

    public CoversReportProvider(CoversReportSearcher searcher) throws BuilderException {
        this(searcher, new PropertiedObject.Property[]{searcher.getPeriodType().getProperty(), CoversReport.Properties.DISPLAY_SECTION, CoversReport.Properties.COVERS, CoversReport.Properties.TOTAL_SALES, CoversReport.Properties.DOLLARS_PER_HEAD}, new String[]{searcher.getPeriodType().getFirstColName(), "Section", "Covers", "Total Sales (inc. " + SystemProperty.getInstance().getBaseTaxLabel() + ")", "Dollars per head"});
    }

    public CoversReportProvider(CoversReportSearcher searcher, PropertiedObject.Property[] coversReportProperties, String[] colTitles) throws BuilderException {
        this.dsProvider = new SearcherDataSourceProvider<CoversReportSearcher>(searcher);
        this.coversSearcher = searcher;
        this.columnProperties = coversReportProperties;
        this.columnTitles = colTitles;
        this.initBuilder();
    }

    private final void initBuilder() throws BuilderException {
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.builder.addReportColumns(Arrays.asList(this.columnProperties), this.columnTitles);
        ReportBuilder.GroupSpec groupSpec = new ReportBuilder.GroupSpec(this.builder.getPropertyColumn(this.columnProperties[0])).setLayout(GroupLayout.DEFAULT).setShowColumnNames(true);
        GroupBuilder groupBuilder = this.builder.addGroupByToBuilder(groupSpec, Arrays.asList(new ReportBuilder.PropertyCalculation(CoversReport.Properties.COVERS, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(CoversReport.Properties.TOTAL_SALES, DJCalculation.SUM)));
        groupBuilder.addFooterVariable((AbstractColumn)this.builder.getPropertyColumn(this.columnProperties[4]), (CustomExpression)new DollarsPerHeadEvaluator("variable-footer_tradingDayName_covers", "variable-footer_tradingDayName_customExpression_for_COLUMN_3"));
        DJGroup group = this.builder.addGroupBuilderToReport(groupBuilder, groupSpec);
        this.builder.createBarChart(group, ReportBuilder.ChartCalculation.SUM, Collections.singletonList(this.builder.getPropertyColumn(this.columnProperties[2])), (byte)1, new DJAxisFormat("Total Patrons"));
        this.builder.getPropertyColumn(this.columnProperties[0]).setWidth(new Integer(150));
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(this.columnProperties[2]), DJCalculation.SUM);
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(this.columnProperties[3]), DJCalculation.SUM);
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(this.columnProperties[4]), new DollarsPerHeadEvaluator("variable-footer_global_covers", "variable-footer_global_customExpression_for_COLUMN_3"));
        this.builder.getReportBuilder().setGrandTotalLegend("Total");
        this.builder.getPropertyColumn(CoversReport.Properties.TOTAL_SALES).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.getPropertyColumn(CoversReport.Properties.COVERS).setPattern("0");
        this.builder.getPropertyColumn(CoversReport.Properties.DOLLARS_PER_HEAD).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
    }

    @Override
    public ReportBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public DynamicReport getReport() throws BuilderException {
        if (this.report == null) {
            if (this.user != null) {
                this.addParam("user", this.user.getName());
            }
            this.report = this.builder.getReportBuilder().build();
        }
        this.report.setTitle(this.getReportTitle());
        this.report.setSubtitle(this.generateSubtitle());
        return this.report;
    }

    private String generateSubtitle() {
        StringBuilder SB = new StringBuilder(this.coversSearcher.getDisplayableDate());
        this.getHelper().appendSubTitleAndValue(SB, "Day Part", this.coversSearcher.getTimeSearchFilter().getDisplayableTime());
        this.getHelper().appendSearchFilter(SB, "Customer", this.coversSearcher.getCustomerFilter());
        this.getHelper().appendSearchFilter(SB, "Customer Category", this.coversSearcher.getCustomerCategoryFilter());
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.coversSearcher.getSalesLocationFilter());
        return SB.toString();
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.dsProvider.getDataSource();
    }

    public CoversReportSearcher getSearcher() {
        return this.coversSearcher;
    }

    public PropertiedObject.Property[] getColumnProperties() {
        return this.columnProperties;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public void setReportTitle(String title) {
        this.reportTitle = title;
    }

    private String getReportTitle() {
        return this.reportTitle;
    }

    public void setUser(User user) {
        this.user = user;
    }

    private User getUser() {
        return this.user;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.coversSearcher.getTradingDayDateRangeFilter());
    }

    private static class DollarsPerHeadEvaluator
    implements CustomExpression {
        private final String coversKey;
        private final String totalSalesKey;

        public DollarsPerHeadEvaluator(String coversKey, String totalSalesKey) {
            this.coversKey = coversKey;
            this.totalSalesKey = totalSalesKey;
        }

        public Object evaluate(Map arg0, Map arg1, Map arg2) {
            BigDecimal total = (BigDecimal)arg1.get(this.totalSalesKey);
            Integer covers = (Integer)arg1.get(this.coversKey);
            if (covers != null && !covers.equals(0)) {
                return new Price(total, 0.01).divide(covers);
            }
            return "N/A";
        }

        public String getClassName() {
            return String.class.getName();
        }
    }
}

