/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysales;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.Date;

public class DailySalesReport
extends PersistentSummaryObject
implements Comparable<DailySalesReport> {
    public static final Props Properties = new Props();
    private Date creationTime;
    private Long accountId;
    private Price sales = Price.ZERO_DOLLAR;
    private int patrons;
    private SalesQuantity tradeVolume = SalesQuantity.ZERO;
    private Date startTime;
    private Date endTime;

    public DailySalesReport() {
    }

    public DailySalesReport(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Price getSales() {
        return this.sales;
    }

    public void setSales(Price sales) {
        this.sales = sales;
    }

    public SalesQuantity getTradeVolume() {
        return this.tradeVolume;
    }

    public void setTradeVolume(SalesQuantity tradeVolume) {
        this.tradeVolume = tradeVolume;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public static String getTimePeriod(Date startTime, Date endTime) {
        if (startTime != null && endTime != null) {
            return DateTimeUtils.get24HFormat().format(startTime) + " - " + DateTimeUtils.get24HFormat().format(endTime);
        }
        return "";
    }

    public String getTimePeriod() {
        return DailySalesReport.getTimePeriod(this.startTime, this.endTime);
    }

    @Override
    public int compareTo(DailySalesReport o) {
        if (this.startTime != null) {
            return this.startTime.compareTo(o.startTime);
        }
        return -1;
    }

    public Double getSalesRaw() {
        return this.sales.doubleValue();
    }

    public Double getTradeVolumeRaw() {
        return this.tradeVolume.getValue().doubleValue();
    }

    public boolean periodHasFigures() {
        return !this.getSales().isZero() || !this.getTradeVolume().equals(SalesQuantity.ZERO);
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long newAccountId) {
        this.accountId = newAccountId;
    }

    public int getPatrons() {
        return this.patrons;
    }

    public void setPatrons(int patrons) {
        this.patrons = patrons;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<Price> SALES;
        public PropertiedObject.Property<Long> ACCOUNT_ID;
        public PropertiedObject.Property PATRONS;
        public PropertiedObject.Property<SalesQuantity> TRADE_VOLUME;
        public PropertiedObject.Property<Date> START_TIME;
        public PropertiedObject.Property<Date> END_TIME;
        public PersistentObject.DerivedProperty<String> TIME_PERIOD = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailySalesReport.class), "timePeriod");
        public PersistentObject.DerivedProperty<Double> SALES_RAW = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailySalesReport.class), "salesRaw");
        public PersistentObject.DerivedProperty<Double> TRADE_VOLUME_RAW = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailySalesReport.class), "tradeVolumeRaw");
    }
}

