/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysales;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.builder.DJLineChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.awt.Color;
import java.text.DateFormat;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.dailysales.DailySalesReport;
import ordermate.database.searchers.reports.dailysales.DailySalesReportCompiler;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.GenericBiListTableModel;

public class DailySalesReportProvider
extends AbstractReportProvider {
    private static final String SALES_DATA_COLUMNS = "SALES_DATA_COLUMNS";
    private static final String CHART_DATA = "CHART_DATA";
    private DailySalesReportCompiler compiler;

    public DailySalesReportProvider(DailySalesReportCompiler theCompiler) {
        this.compiler = theCompiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.getResults());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.addParam(SALES_DATA_COLUMNS, new JRTableModelDataSource(new GenericBiListTableModel(this.compiler.getDailySalesFiguresColumnNamesList(), this.compiler.getDailySalesFiguresReportData())));
        this.addParam(CHART_DATA, new JRBeanCollectionDataSource(this.compiler.getResults()));
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle(){

            @Override
            protected Style constructFooterVariableStyle() {
                Style style = super.constructFooterVariableStyle();
                style.setFont(Font.ARIAL_SMALL);
                return style;
            }

            @Override
            protected Style constructGroupedDetailStyle() {
                Style style = super.constructGroupedDetailStyle();
                style.setFont(Font.ARIAL_BIG_BOLD);
                return style;
            }
        });
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Half Hourly Sales Breakdown");
        StringBuilder SB = new StringBuilder();
        if (this.compiler.getSearcher().getTradingDayFilter().hasSearchValue()) {
            SB.append("Half Hourly Sales Breakdown for: ").append(DateFormat.getDateInstance().format(this.compiler.getSearcher().getTradingDayFilter().getSearchValue().getDate()));
        } else if (this.compiler.getSearcher().getTradingDayDateFilter().hasSearchValue()) {
            SB.append("Half Hourly Sales Breakdown for: ").append(DateFormat.getDateInstance().format(this.compiler.getSearcher().getTradingDayDateFilter().getSearchValue()));
        }
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.compiler.getSearcher().getSalesLocationFilter());
        builder.setSubtitle(SB.toString());
        try {
            builder.getReportBuilder().addConcatenatedReport(this.generateDailySalesReport(), (LayoutManager)new ClassicLayoutManager(), SALES_DATA_COLUMNS, 0, 10, false);
            builder.getReportBuilder().addConcatenatedReport(this.generateChartSubReport(), (LayoutManager)new ClassicLayoutManager(), CHART_DATA, 0, 10, false);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.warn("Cannot build sub reports", (Throwable)ex);
        }
        return builder;
    }

    private void addChart(ReportBuilder builder) throws BuilderException {
        DJLineChartBuilder chartBuilder = new DJLineChartBuilder();
        chartBuilder.setX(20).setY(10).setWidth(500).setHeight(500).setCentered(true).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)2).setTitle("Daily Sales").setTitleColor(Color.DARK_GRAY).setLegendColor(Color.DARK_GRAY).setLegendBackgroundColor(Color.WHITE).setLegendPosition((byte)2).setTitlePosition((byte)1).setLineStyle((byte)2).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setCategory(builder.getPropertyColumn(DailySalesReport.Properties.TIME_PERIOD)).setValueAxisFormat(new DJAxisFormat("Sales (" + Internationalization.getLiteralFor("DOLLAR_SIGN") + ") / Volume")).addSerie((AbstractColumn)builder.getPropertyColumn(DailySalesReport.Properties.SALES_RAW), "Sales").addSerie((AbstractColumn)builder.getPropertyColumn(DailySalesReport.Properties.TRADE_VOLUME_RAW), "Trade Volume");
        DJChart build = chartBuilder.build();
        build.getPlot().setLabelRotation(Double.valueOf(90.0));
        builder.getReportBuilder().addChart(build);
    }

    private DynamicReport generateChartSubReport() throws BuilderException {
        ReportBuilder chartSubReportBuilder = new ReportBuilder();
        chartSubReportBuilder.addInvisibleField(DailySalesReport.Properties.TIME_PERIOD);
        chartSubReportBuilder.addInvisibleField(DailySalesReport.Properties.SALES_RAW);
        chartSubReportBuilder.addInvisibleField(DailySalesReport.Properties.TRADE_VOLUME_RAW);
        this.addChart(chartSubReportBuilder);
        return chartSubReportBuilder.buildJasperReport();
    }

    private DynamicReport generateDailySalesReport() {
        ReportBuilder dataSubReportBuilder = new ReportBuilder();
        for (Map.Entry<String, String> entry : this.compiler.getDailySalesFiguresColumns().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            SimpleColumn column = JasperReportHelper.createSimpleColumn(key, String.class);
            column.setTitle(value);
            dataSubReportBuilder.getReportBuilder().addColumn((AbstractColumn)column);
            dataSubReportBuilder.getReportBuilder().setUseFullPageWidth(true);
        }
        return dataSubReportBuilder.buildJasperReport();
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeSingleValueFilter(this.compiler.getSearcher().getTradingDayDateFilter());
    }
}

