/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.dailysummary.DailyReportI;
import ordermate.database.reports.dailysummary.DailyReportIComparator;

public abstract class AbstractDailySummaryReportCompiler<T extends DailyReportI> {
    public abstract List<List<String>> getReportData();

    protected abstract T createEmptyReport(Integer var1);

    protected abstract String getPrimaryColumnName();

    public List<String> getColumnNames() {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add(this.getPrimaryColumnName());
        newList.add("Mon");
        newList.add("Tue");
        newList.add("Wed");
        newList.add("Thu");
        newList.add("Fri");
        newList.add("Sat");
        newList.add("Sun");
        newList.add("Total");
        return newList;
    }

    protected void sortListByDayOfWeek(List<? extends DailyReportI> toSort) {
        Collections.sort(toSort, new DailyReportIComparator());
    }

    protected Map<Integer, T> mapByDayOfWeek(Collection<T> tSet) {
        HashMap<Integer, DailyReportI> newMap = new HashMap<Integer, DailyReportI>();
        for (DailyReportI nextT : tSet) {
            if (nextT.getDayOfWeek() == null) continue;
            newMap.put(nextT.getDayOfWeek(), nextT);
        }
        return newMap;
    }

    protected void insertMissingReports(Map<Integer, T> reports) {
        if (reports.size() != 7) {
            HashSet<Integer> missingSet = new HashSet<Integer>();
            for (int i = 0; i < 7; ++i) {
                missingSet.add(i + 1);
            }
            for (Integer nextDay : reports.keySet()) {
                missingSet.remove(nextDay);
            }
            for (Integer nextDay : missingSet) {
                reports.put(nextDay, this.createEmptyReport(nextDay));
            }
        }
    }

    protected List<T> createColumnarTotalsReports(Map<String, List<T>> reportMap) {
        ArrayList<T> columnTotals = new ArrayList<T>();
        for (int i = 0; i < 7; ++i) {
            columnTotals.add(this.createEmptyReport(i + 1));
        }
        columnTotals.add(this.createEmptyReport(null));
        for (List<T> nextList : reportMap.values()) {
            for (int i = 0; i < nextList.size(); ++i) {
                ((DailyReportI)columnTotals.get(i)).add((DailyReportI)nextList.get(i));
            }
        }
        return columnTotals;
    }

    protected void addRowTotalsReport(Map<Integer, T> reports) {
        T report = this.createEmptyReport(null);
        for (DailyReportI nextReport : reports.values()) {
            report.add(nextReport);
        }
        reports.put(null, report);
    }
}

