/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.dailysummary.AbstractDailySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyDebtorSummaryReport;

public class DailyDebtorSummaryReportCompiler
extends AbstractDailySummaryReportCompiler<DailyDebtorSummaryReport> {
    private List<List<String>> rows;

    public DailyDebtorSummaryReportCompiler(List<DailyDebtorSummaryReport> paymentsReports, List<DailyDebtorSummaryReport> salesReports, List<DailyDebtorSummaryReport> adjustmentsReports) {
        Map<Integer, DailyDebtorSummaryReport> primaryMap = this.mapByDayOfWeek(paymentsReports);
        this.insertMissingReports(primaryMap);
        Map<Integer, DailyDebtorSummaryReport> salesMap = this.mapByDayOfWeek(salesReports);
        this.addReports(primaryMap, salesMap);
        Map<Integer, DailyDebtorSummaryReport> adjMap = this.mapByDayOfWeek(adjustmentsReports);
        this.addReports(primaryMap, adjMap);
        this.addRowTotalsReport(primaryMap);
        ArrayList<DailyDebtorSummaryReport> sortedList = new ArrayList<DailyDebtorSummaryReport>(primaryMap.values());
        this.sortListByDayOfWeek(sortedList);
        this.makeSummaryData(sortedList);
    }

    private void addReports(Map<Integer, DailyDebtorSummaryReport> map1, Map<Integer, DailyDebtorSummaryReport> map2) {
        for (Integer nextDay : map1.keySet()) {
            DailyDebtorSummaryReport report = map2.get(nextDay);
            if (report == null) continue;
            map1.get(nextDay).add(report);
        }
    }

    @Override
    protected DailyDebtorSummaryReport createEmptyReport(Integer theDayOfWeek) {
        return new DailyDebtorSummaryReport(theDayOfWeek);
    }

    @Override
    protected String getPrimaryColumnName() {
        return "Activity";
    }

    private void makeSummaryData(List<DailyDebtorSummaryReport> sortedReports) {
        this.rows = new ArrayList<List<String>>();
        ArrayList<String> payments = new ArrayList<String>();
        payments.add("Nett Cust Account Paid");
        ArrayList<String> sales = new ArrayList<String>();
        sales.add("Nett Cust Account Added");
        ArrayList<String> discount = new ArrayList<String>();
        discount.add("Cust Account Discount");
        ArrayList<String> surcharge = new ArrayList<String>();
        surcharge.add("Cust Account Surcharge");
        ArrayList<String> unadjusted = new ArrayList<String>();
        unadjusted.add("Account Paid Ex Adj");
        for (DailyDebtorSummaryReport report : sortedReports) {
            payments.add(report.getPayments().toString(true));
            sales.add(report.getSales().toString(true));
            discount.add(report.getDiscounts().toString(true));
            surcharge.add(report.getSurcharges().toString(true));
            unadjusted.add(report.getPayments().subtract(report.getSurcharges()).subtract(report.getDiscounts()).toString(true));
        }
        this.rows.add(sales);
        this.rows.add(payments);
        this.rows.add(discount);
        this.rows.add(surcharge);
        this.rows.add(unadjusted);
    }

    @Override
    public List<List<String>> getReportData() {
        return this.rows;
    }
}

