/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.persistence.PropertiedObject;
import ordermate.database.hardware.physical.kts.KTSDocketDataSummary;
import ordermate.database.reports.dailysummary.DailyReportI;

public class DailyKTSReport
extends KTSDocketDataSummary
implements DailyReportI {
    public static final Props Properties = new Props();
    private Integer dayOfWeek;

    @Override
    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(Integer value) {
        this.dayOfWeek = value;
    }

    @Override
    public void add(DailyReportI otherReport) {
        long tally;
        DailyKTSReport report = (DailyKTSReport)otherReport;
        int totalCount = this.getSize() + report.getSize();
        if (this.getAverageHoldTime() == 0) {
            this.setAverageHoldTime(report.getAverageHoldTime());
        } else if (report.getAverageHoldTime() != 0) {
            tally = this.getAverageHoldTime() / 1000 * this.getSize() + report.getAverageHoldTime() / 1000 * report.getSize();
            this.setAverageHoldTime((tally *= 1000L) == 0L ? 0 : (int)(tally / (long)totalCount));
        }
        tally = 0L;
        if (this.getAverageLiveTime() == 0) {
            this.setAverageLiveTime(report.getAverageLiveTime());
        } else {
            tally = this.getAverageLiveTime() / 1000 * this.getSize() + report.getAverageLiveTime() / 1000 * report.getSize();
            this.setAverageLiveTime((tally *= 1000L) == 0L ? 0 : (int)(tally / (long)totalCount));
        }
        if (this.getLowestTime() == 0) {
            this.setLowestTime(report.getLowestTime());
        } else if (report.getLowestTime() != 0) {
            this.setLowestTime(Math.min(this.getLowestTime(), report.getLowestTime()));
        }
        if (this.getHighestTime() == 0) {
            this.setHighestTime(report.getHighestTime());
        } else if (report.getHighestTime() != 0) {
            this.setHighestTime(Math.max(this.getHighestTime(), report.getHighestTime()));
        }
        this.setSize(totalCount);
    }

    public static class Props
    extends KTSDocketDataSummary.Props {
        public PropertiedObject.Property<Integer> DAY_OF_WEEK;
    }
}

