/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.dailysummary.AbstractDailySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyKTSReport;

public class DailyKTSReportCompiler
extends AbstractDailySummaryReportCompiler<DailyKTSReport> {
    private List<List<String>> data;

    public DailyKTSReportCompiler(List<DailyKTSReport> yourReports) {
        Map<Integer, DailyKTSReport> reportMap = this.mapByDayOfWeek(yourReports);
        this.insertMissingReports(reportMap);
        this.addRowTotalsReport(reportMap);
        ArrayList<DailyKTSReport> sortedList = new ArrayList<DailyKTSReport>(reportMap.values());
        this.sortListByDayOfWeek(sortedList);
        this.compileData(sortedList);
    }

    @Override
    public List<String> getColumnNames() {
        List<String> superList = super.getColumnNames();
        superList.set(superList.size() - 1, "Tot/Avg");
        return superList;
    }

    @Override
    public List<List<String>> getReportData() {
        return this.data;
    }

    private void compileData(List<DailyKTSReport> sortedReports) {
        this.data = new ArrayList<List<String>>();
        ArrayList<String> average = new ArrayList<String>();
        ArrayList<String> hold = new ArrayList<String>();
        ArrayList<String> live = new ArrayList<String>();
        ArrayList<String> max = new ArrayList<String>();
        ArrayList<String> min = new ArrayList<String>();
        ArrayList<String> count = new ArrayList<String>();
        average.add("Average Total");
        hold.add("Average Hold");
        live.add("Average Live");
        max.add("Longest");
        min.add("Shortest");
        count.add("Count");
        for (DailyKTSReport report : sortedReports) {
            average.add(this.toMinsSeconds(report.getAverageTotalTime()));
            hold.add(this.toMinsSeconds(report.getAverageHoldTime()));
            live.add(this.toMinsSeconds(report.getAverageLiveTime()));
            max.add(this.toMinsSeconds(report.getHighestTime()));
            min.add(this.toMinsSeconds(report.getLowestTime()));
            count.add(String.valueOf(report.getSize()));
        }
        this.data.add(average);
        this.data.add(hold);
        this.data.add(live);
        this.data.add(max);
        this.data.add(min);
        this.data.add(count);
    }

    private String toMinsSeconds(int value) {
        if (value == 0) {
            return "-";
        }
        int seconds = value / 1000;
        int minutes = seconds / 60;
        seconds %= 60;
        StringBuilder SB = new StringBuilder();
        if (minutes > 0) {
            SB.append(minutes).append("m ");
        }
        SB.append(seconds).append("s");
        return SB.toString();
    }

    @Override
    protected DailyKTSReport createEmptyReport(Integer theDayOfWeek) {
        DailyKTSReport report = new DailyKTSReport();
        report.setDayOfWeek(theDayOfWeek);
        return report;
    }

    @Override
    protected String getPrimaryColumnName() {
        return "Times";
    }
}

