/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.reports.StaffCostReportSummary;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.reports.dailysummary.DailyReportI;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;

public class DailyProductivitySummaryReport
extends TotalsReport
implements DailyReportI {
    public static final Props Properties = new Props();
    private Integer dayOfWeek;
    private Integer numPatrons = 0;
    private Price labourCost = Price.ZERO_DOLLAR;
    private Double labourHours = 0.0;
    private DailySalesSummaryReport totalReport = null;
    private Price totalSalesEx = Price.ZERO_DOLLAR;

    public DailyProductivitySummaryReport() {
    }

    public DailyProductivitySummaryReport(Integer theDayOfWeek) {
        this.dayOfWeek = theDayOfWeek;
    }

    @Override
    public void add(DailyReportI otherReport) {
        DailyProductivitySummaryReport report = (DailyProductivitySummaryReport)otherReport;
        this.setCount(this.getCount() + report.getCount());
        this.setTotal(this.getTotal().add(report.getTotal()));
        this.setTotalTax(this.getTotalTax().add(report.getTotalTax()));
        this.setNumPatrons(this.numPatrons + report.getNumPatrons());
        this.labourCost = this.labourCost.add(report.getLabourCost());
        this.labourHours = this.labourHours + report.getLabourHours();
        this.totalSalesEx = this.totalSalesEx.add(report.getTotalSalesEx());
        if (this.totalReport != null && report.totalReport != null) {
            this.totalReport.add(report.totalReport);
        } else if (report.totalReport != null) {
            this.totalReport = new DailySalesSummaryReport(report.totalReport);
        }
    }

    @Override
    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    protected void setDayOfWeek(Integer value) {
        this.dayOfWeek = value;
    }

    public Integer getNumPatrons() {
        return this.numPatrons;
    }

    public Double getPatronsPerService() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        return this.getNumPatrons().doubleValue() / (double)this.getCount().longValue();
    }

    protected void setNumPatrons(Integer value) {
        this.numPatrons = value;
    }

    public Price getLabourCost() {
        return this.labourCost;
    }

    public Price getTotalSalesEx() {
        return this.totalSalesEx;
    }

    public void setTotalSalesEx(Price value) {
        this.totalSalesEx = value;
    }

    public Double getLabourHours() {
        return this.labourHours;
    }

    protected void setLabourHours(Double value) {
        this.labourHours = value;
    }

    protected void setLabourCost(Price value) {
        this.labourCost = value;
    }

    public Double getLabourPerc() {
        if (this.totalSalesEx == null || this.totalSalesEx.equals(Price.ZERO_DOLLAR)) {
            return 1.0;
        }
        return this.getLabourCost().doubleValue() / this.totalSalesEx.doubleValue();
    }

    public Price getAvgHourlyRate() {
        if (this.labourHours == null || this.labourHours == 0.0) {
            return Price.ZERO_DOLLAR;
        }
        return this.labourCost.divide(this.labourHours);
    }

    public void setStaffSummary(StaffCostReportSummary staffSummary) {
        this.labourCost = staffSummary.getStaffCost();
        this.labourHours = staffSummary.getTotalLabourHours();
    }

    public void applyPatrons(DailyPatronsReport count) {
        this.numPatrons = count.getNumPatrons();
    }

    public void applySalesSummary(DailySalesSummaryReport dailyReport) {
        this.totalReport = dailyReport;
        this.totalSalesEx = this.totalSalesEx.add(dailyReport.getSalesEx());
    }

    public Price getSalesPerLabourHour() {
        if (this.labourHours == null || this.labourHours == 0.0 || this.totalReport == null) {
            return null;
        }
        return this.totalSalesEx.divide(this.labourHours);
    }

    public Double getCoversPerLabourHour() {
        if (this.labourHours == null || this.labourHours == 0.0 || this.numPatrons == null) {
            return null;
        }
        return MathsUtils.roundDouble(this.numPatrons.doubleValue() / this.labourHours, 0.01);
    }

    public static class Props
    extends TotalsReport.Props {
        public PropertiedObject.Property<Integer> DAY_OF_WEEK;
        public PropertiedObject.Property<Integer> NUM_PATRONS;
        public PersistentObject.DerivedProperty<Price> SALES_PER_LABOUR_HOUR = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailyProductivitySummaryReport.class), "salesPerLabourHour");
        public PersistentObject.DerivedProperty<Double> COVERS_PER_LABOUR_HOUR = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailyProductivitySummaryReport.class), "coversPerLabourHour");
    }
}

