/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.StaffCostReportHelper;
import ordermate.database.reports.StaffCostReportSummary;
import ordermate.database.reports.dailysummary.AbstractDailySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReport;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.internationalization.Internationalization;

public class DailyProductivitySummaryReportCompiler
extends AbstractDailySummaryReportCompiler<DailyProductivitySummaryReport> {
    private List<List<String>> data;
    private final Date start;
    private final Date end;

    public DailyProductivitySummaryReportCompiler(Date startDate) {
        this.start = startDate;
        this.end = null;
    }

    public DailyProductivitySummaryReportCompiler(Date startDate, Date endDate) {
        this.start = startDate;
        this.end = endDate;
    }

    public void compile(List<DailyProductivitySummaryReport> reports, List<DailyPatronsReport> patrons, List<DailySalesSummaryReport> totalSales) {
        Map<Integer, DailyProductivitySummaryReport> dayMap = this.mapByDayOfWeek(reports);
        this.insertMissingReports(dayMap);
        this.collateData(dayMap);
        this.applyPatrons(dayMap, patrons);
        this.applyTotalSales(dayMap, totalSales);
        this.addRowTotalsReport(dayMap);
        ArrayList<DailyProductivitySummaryReport> sortedList = new ArrayList<DailyProductivitySummaryReport>(dayMap.values());
        this.sortListByDayOfWeek(sortedList);
        this.makeData(sortedList);
    }

    private void collateData(Map<Integer, DailyProductivitySummaryReport> dayMap) {
        StaffCostReportHelper staffCostReportHelper = new StaffCostReportHelper();
        List<StaffCostReportSummary> staffSummaries = this.createStaffSummaries(staffCostReportHelper);
        for (int i = 0; i < staffSummaries.size(); ++i) {
            Integer dow = DateTimeUtils.getDayOfWeek(staffSummaries.get(i).getStartTime());
            DailyProductivitySummaryReport summaryProductivity = dayMap.get(dow);
            double labourHours = summaryProductivity.getLabourHours() + staffSummaries.get(i).getTotalLabourHours();
            Price labourCost = summaryProductivity.getLabourCost().add(staffSummaries.get(i).getStaffCost());
            summaryProductivity.setLabourHours(labourHours);
            summaryProductivity.setLabourCost(labourCost);
        }
    }

    private void applyPatrons(Map<Integer, DailyProductivitySummaryReport> dayMap, List<DailyPatronsReport> patrons) {
        if (patrons == null || patrons.isEmpty()) {
            return;
        }
        for (DailyPatronsReport count : patrons) {
            if (count.getDayOfWeek() == null) continue;
            dayMap.get(count.getDayOfWeek()).applyPatrons(count);
        }
    }

    private void applyTotalSales(Map<Integer, DailyProductivitySummaryReport> dayMap, List<DailySalesSummaryReport> sales) {
        if (sales == null || sales.isEmpty()) {
            return;
        }
        for (DailySalesSummaryReport salesReport : sales) {
            DailyProductivitySummaryReport report = dayMap.get(salesReport.getDayOfWeek());
            if (report == null) continue;
            report.applySalesSummary(salesReport);
        }
    }

    private void makeData(List<DailyProductivitySummaryReport> reports) {
        this.data = new ArrayList<List<String>>();
        DecimalFormat doubleFormat = new DecimalFormat("#0.00");
        List<String> labourHours = this.newList("Labour Hours");
        List<String> avgHourlyRate = this.newList("Avg Hourly Rate");
        List<String> labourCost = this.newList("Labour Cost");
        List<String> labourPerc = this.newList("Labour %");
        List<String> accountCount = this.newList("Service Count");
        List<String> totalPatrons = this.newList("Total " + Internationalization.getLiteralFor("COVERS"));
        List<String> patronsPerService = this.newList(Internationalization.getLiteralFor("COVERS") + " / Service");
        List<String> salesPerLabourHour = this.newList("Sales / Labour Hour");
        List<String> coversPerLabourHour = this.newList(Internationalization.getLiteralFor("COVERS") + " / Labour Hour");
        for (DailyProductivitySummaryReport report : reports) {
            labourHours.add(doubleFormat.format(MathsUtils.roundDouble(report.getLabourHours(), 0.01)));
            avgHourlyRate.add(doubleFormat.format(report.getAvgHourlyRate().doubleValue()));
            labourCost.add(report.getLabourCost().toString(true));
            labourPerc.add(FinanceUtils.formatAsPercentage(report.getLabourPerc() * 100.0, doubleFormat));
            accountCount.add(Long.toString(report.getCount()));
            totalPatrons.add(report.getNumPatrons().toString());
            patronsPerService.add(doubleFormat.format(MathsUtils.roundDouble(report.getPatronsPerService(), 0.01)));
            Number value = report.getSalesPerLabourHour();
            salesPerLabourHour.add(value == null ? "" : value.toString());
            value = report.getCoversPerLabourHour();
            coversPerLabourHour.add(value == null ? "" : value.toString());
        }
    }

    public List<StaffCostReportSummary> createStaffSummaries(StaffCostReportHelper helper) {
        return this.createStaffSummaries(helper, null);
    }

    public List<StaffCostReportSummary> createStaffSummaries(StaffCostReportHelper helper, List<SalesLocation> salesLocations) {
        ArrayList<StaffCostReportSummary> staffSummaries = new ArrayList<StaffCostReportSummary>();
        ObjectQuery tradeDayQuery = new ObjectQuery().select(TradingDay.class).whereFunction("TIMESTAMP(day, time) >= '" + DateTimeUtils.getSQLTimestampFormat().format(this.start) + "'");
        if (this.end == null) {
            tradeDayQuery.limit(7);
        } else {
            tradeDayQuery.whereFunction("TIMESTAMP(day, time) < '" + DateTimeUtils.getSQLTimestampFormat().format(this.end) + "'");
        }
        List<TradingDay> days = PersistenceManager.getObjectList(TradingDay.class, tradeDayQuery.orderBy("day", false).toString());
        for (int i = 0; i < days.size(); ++i) {
            Date dayStart = days.get(i).getOpenDateTime();
            Date dayEnd = days.get(i).getCloseDateTime();
            staffSummaries.add(helper.getStaffCostReportSummary(dayStart, dayEnd, salesLocations));
        }
        return staffSummaries;
    }

    private List<String> newList(String name) {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add(name);
        this.data.add(newList);
        return newList;
    }

    @Override
    public List<List<String>> getReportData() {
        return this.data;
    }

    @Override
    protected DailyProductivitySummaryReport createEmptyReport(Integer theDayOfWeek) {
        return new DailyProductivitySummaryReport(theDayOfWeek);
    }

    @Override
    protected String getPrimaryColumnName() {
        return "Summary";
    }
}

