/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.OverRingEntry;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.reports.dailysummary.AbstractDailyReport;
import ordermate.database.reports.dailysummary.DailyReportI;

public class DailyReconciliationSummaryReport
extends AbstractDailyReport {
    public static final Props Properties = new Props();
    private Reference<CashDrawer> cashDrawer;
    private Price expectedCash;
    private Price actualCash;
    private Price expectedCard;
    private Price actualCard;
    private Price expectedWeb;
    private Price actualWeb;
    private Price expectedCashOut;
    private Price actualCashOut;
    private Price actualPetty;
    private Price actualTips;
    private Price actualOverring;
    private Price expectedBreakoutAdjustment;
    private Price actualBreakoutAdjustment;

    public DailyReconciliationSummaryReport() {
        this.cashDrawer = this.createReference(DailyReconciliationSummaryReport.Properties.CASH_DRAWER);
        this.expectedCash = Price.ZERO_DOLLAR;
        this.actualCash = Price.ZERO_DOLLAR;
        this.expectedCard = Price.ZERO_DOLLAR;
        this.actualCard = Price.ZERO_DOLLAR;
        this.expectedWeb = Price.ZERO_DOLLAR;
        this.actualWeb = Price.ZERO_DOLLAR;
        this.expectedCashOut = Price.ZERO_DOLLAR;
        this.actualCashOut = Price.ZERO_DOLLAR;
        this.actualPetty = Price.ZERO_DOLLAR;
        this.actualTips = Price.ZERO_DOLLAR;
        this.actualOverring = Price.ZERO_DOLLAR;
        this.expectedBreakoutAdjustment = Price.ZERO_DOLLAR;
        this.actualBreakoutAdjustment = Price.ZERO_DOLLAR;
    }

    public DailyReconciliationSummaryReport(Integer dayOfWeek, CashDrawer theCashDrawer) {
        super(dayOfWeek);
        this.cashDrawer = this.createReference(DailyReconciliationSummaryReport.Properties.CASH_DRAWER);
        this.expectedCash = Price.ZERO_DOLLAR;
        this.actualCash = Price.ZERO_DOLLAR;
        this.expectedCard = Price.ZERO_DOLLAR;
        this.actualCard = Price.ZERO_DOLLAR;
        this.expectedWeb = Price.ZERO_DOLLAR;
        this.actualWeb = Price.ZERO_DOLLAR;
        this.expectedCashOut = Price.ZERO_DOLLAR;
        this.actualCashOut = Price.ZERO_DOLLAR;
        this.actualPetty = Price.ZERO_DOLLAR;
        this.actualTips = Price.ZERO_DOLLAR;
        this.actualOverring = Price.ZERO_DOLLAR;
        this.expectedBreakoutAdjustment = Price.ZERO_DOLLAR;
        this.actualBreakoutAdjustment = Price.ZERO_DOLLAR;
        this.setCashDrawer(theCashDrawer);
        this.expectedCash = Price.ZERO_DOLLAR;
        this.expectedCard = Price.ZERO_DOLLAR;
        this.expectedCashOut = Price.ZERO_DOLLAR;
        this.actualCash = Price.ZERO_DOLLAR;
        this.actualCard = Price.ZERO_DOLLAR;
        this.actualCashOut = Price.ZERO_DOLLAR;
        this.actualPetty = Price.ZERO_DOLLAR;
        this.actualTips = Price.ZERO_DOLLAR;
        this.actualOverring = Price.ZERO_DOLLAR;
    }

    @Override
    public void add(DailyReportI otherReport) {
        DailyReconciliationSummaryReport report = (DailyReconciliationSummaryReport)otherReport;
        this.expectedCash = this.expectedCash.add(report.getExpectedCash());
        this.expectedCard = this.expectedCard.add(report.getExpectedCard());
        this.expectedCashOut = this.expectedCashOut.add(report.getExpectedCashOut());
        this.actualCashOut = this.actualCashOut.add(report.getActualCashOut());
        this.actualCash = this.actualCash.add(report.getActualCash());
        this.actualCard = this.actualCard.add(report.getActualCard());
        this.actualPetty = this.actualPetty.add(report.getActualPetty());
        this.actualTips = this.actualTips.add(report.getActualTips());
        this.actualOverring = this.actualOverring.add(report.getActualOverring());
        this.actualWeb = this.actualWeb.add(report.getActualWeb());
        this.expectedWeb = this.expectedWeb.add(report.getExpectedWeb());
        this.expectedBreakoutAdjustment = this.expectedBreakoutAdjustment.add(report.expectedBreakoutAdjustment);
        this.actualBreakoutAdjustment = this.actualBreakoutAdjustment.add(report.actualBreakoutAdjustment);
    }

    public Price getExpectedCash() {
        return this.expectedCash;
    }

    protected void setExpectedCash(Price value) {
        this.expectedCash = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getActualCash() {
        return this.actualCash;
    }

    protected void setActualCash(Price value) {
        this.actualCash = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getExpectedCashOut() {
        return this.expectedCashOut;
    }

    protected void setExpectedCashOut(Price value) {
        this.expectedCashOut = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getActualCashOut() {
        return this.actualCashOut;
    }

    protected void setActualCashOut(Price value) {
        this.actualCashOut = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getExpectedCard() {
        return this.expectedCard;
    }

    protected void setExpectedCard(Price value) {
        this.expectedCard = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getActualCard() {
        return this.actualCard;
    }

    protected void setActualCard(Price value) {
        this.actualCard = value == null ? Price.ZERO_DOLLAR : value;
    }

    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    protected void setCashDrawer(CashDrawer value) {
        this.cashDrawer.set(value);
    }

    public Price getVariance() {
        Price expected = this.getExpectedCard().add(this.getExpectedCash()).add(this.getExpectedWeb().subtract(this.getExpectedCashOut()).add(this.expectedBreakoutAdjustment));
        Price actual = this.getActualCard().add(this.getActualCash()).add(this.getActualOverring()).add(this.getActualPetty()).add(this.getActualWeb()).add(this.actualBreakoutAdjustment);
        return actual.subtract(expected);
    }

    public Price getActualPetty() {
        return this.actualPetty;
    }

    protected void setActualPetty(Price value) {
        this.actualPetty = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getActualTips() {
        return this.actualTips;
    }

    protected void setActualTips(Price value) {
        this.actualTips = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getActualOverring() {
        return this.actualOverring;
    }

    protected void setActualOverring(Price value) {
        this.actualOverring = value == null ? Price.ZERO_DOLLAR : value;
    }

    public Price getActualWeb() {
        return this.actualWeb;
    }

    protected void setActualWeb(Price value) {
        this.actualWeb = value;
    }

    public Price getExpectedWeb() {
        return this.expectedWeb;
    }

    protected void setExpectedWeb(Price value) {
        this.expectedWeb = value;
    }

    public void applyCashdrawerReconciliation(CashdrawerReconciliation cashDrawerReconciliation) {
        this.actualCash = this.actualCash.add(cashDrawerReconciliation.getTotalCashLessFloat());
        this.actualPetty = this.actualPetty.add(cashDrawerReconciliation.getPettyCashTotal());
        this.actualTips = this.actualTips.add(cashDrawerReconciliation.getTipsTotal());
        OverRingEntry overring = cashDrawerReconciliation.getOverringEntry();
        if (overring != null) {
            this.actualOverring = this.actualOverring.add(overring.getValue());
        }
        this.actualCard = this.actualCard.add(cashDrawerReconciliation.getCreditTotal());
        this.actualWeb = this.actualWeb.add(cashDrawerReconciliation.getWebTotal());
        this.actualCashOut = this.actualCashOut.add(cashDrawerReconciliation.getCashOutTotal());
    }

    public void applyExpectedBreakoutAdjustment(Price toAdjust) {
        this.expectedBreakoutAdjustment = this.expectedBreakoutAdjustment.add(toAdjust);
        this.setExpectedCard(this.getExpectedCard().subtract(toAdjust));
    }

    public void applyActualBreakoutAdjustment(Price toAdjust) {
        this.actualBreakoutAdjustment = this.actualBreakoutAdjustment.add(toAdjust);
        this.setActualCard(this.getActualCard().subtract(toAdjust));
    }

    public static class Props
    extends AbstractDailyReport.Props {
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<Price> EXPECTED_CASH;
        public PropertiedObject.Property<Price> ACTUAL_CASH;
        public PropertiedObject.Property<Price> EXPECTED_CARD;
        public PropertiedObject.Property<Price> ACTUAL_CARD;
        public PropertiedObject.Property<Price> EXPECTED_WEB;
        public PropertiedObject.Property<Price> ACTUAL_WEB;
        public PropertiedObject.Property<Price> EXPECTED_CASH_OUT;
        public PropertiedObject.Property<Price> ACTUAL_CASH_OUT;
        public PropertiedObject.Property<Price> ACTUAL_PETTY;
        public PropertiedObject.Property<Price> ACTUAL_TIPS;
        public PropertiedObject.Property<Price> ACTUAL_OVERRING;
        public PersistentObject.DerivedProperty<Price> VARIANCE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailyReconciliationSummaryReport.class), "variance");
    }
}

