/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.reconciliation.entries.CreditEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.reports.dailysummary.AbstractDailySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyReconciliationSummaryReport;
import ordermate.database.reports.dailysummary.DailyReportI;
import ordermate.database.reports.dailysummary.DailyReportIComparator;
import ordermate.database.searchers.reports.dailysummary.DailyReconciliationSummaryReportSearcher;

public class DailyReconciliationSummaryReportCompiler
extends AbstractDailySummaryReportCompiler<DailyReconciliationSummaryReport> {
    public static final String BREAKOUT = "Card Breakout";
    private Map<CashDrawer, List<DailyReconciliationSummaryReport>> reports;
    private CashDrawer currentCashdrawer;
    private DailyReconciliationSummaryReportSearcher searcher;
    private Map<CashDrawer, Map<FinanceUnit, List<Breakout>>> breakoutReports;
    private List<FinanceUnit> breakoutUnits;

    public DailyReconciliationSummaryReportCompiler(DailyReconciliationSummaryReportSearcher yourSearcher) {
        this.searcher = yourSearcher;
        List initialReports = this.searcher.search();
        List<ShiftReconciliation> recs = this.searcher.getReconciliations();
        List<CashDrawer> activeDrawers = PersistenceManager.getObjectList(CashDrawer.class, Query.select(CashDrawer.class).active(CashDrawer.class).toString());
        this.reports = new HashMap<CashDrawer, List<DailyReconciliationSummaryReport>>();
        for (CashDrawer drawer : activeDrawers) {
            this.reports.put(drawer, new ArrayList());
        }
        for (DailyReconciliationSummaryReport report : initialReports) {
            this.reports.get(report.getCashDrawer()).add(report);
        }
        this.breakoutReports = this.getBreakouts();
        HashMap<Integer, List<ShiftReconciliation>> recMap = new HashMap<Integer, List<ShiftReconciliation>>();
        Calendar cal = Calendar.getInstance();
        for (ShiftReconciliation rec : recs) {
            cal.setTime(rec.getShift().getTradingDay().getOpenDateTime());
            Integer dayOfWeek = DateTimeUtils.getDayOfWeek(cal.getTime());
            if (!recMap.containsKey(dayOfWeek)) {
                recMap.put(dayOfWeek, new ArrayList());
            }
            ((List)recMap.get(dayOfWeek)).add(rec);
        }
        Iterator<PersistentObject> iterator = this.reports.keySet().iterator();
        while (iterator.hasNext()) {
            CashDrawer drawer;
            this.currentCashdrawer = drawer = (CashDrawer)iterator.next();
            List<DailyReconciliationSummaryReport> reportList = this.reports.get(drawer);
            Map<Integer, DailyReconciliationSummaryReport> reportMap = this.mapByDayOfWeek(reportList);
            this.insertMissingReports(reportMap);
            this.applyReconciliations(recMap, reportMap);
            this.applyBreakouts(reportMap, drawer);
            this.addRowTotalsReport(reportMap);
            reportList = new ArrayList<DailyReconciliationSummaryReport>(reportMap.values());
            this.reports.put(drawer, reportList);
            this.sortListByDayOfWeek(reportList);
        }
        if (activeDrawers.size() > 1) {
            this.reports.put(null, new ArrayList());
            this.reports.get(null).addAll(this.getTotals(this.reports.values()));
        }
    }

    private void applyReconciliations(Map<Integer, List<ShiftReconciliation>> recMap, Map<Integer, DailyReconciliationSummaryReport> map) {
        for (Integer nextDay : map.keySet()) {
            if (recMap.get(nextDay) == null) continue;
            for (ShiftReconciliation nextShiftRec : recMap.get(nextDay)) {
                CashdrawerReconciliation cashRec = nextShiftRec.getCashDrawerReconciliation(this.currentCashdrawer);
                if (cashRec == null) continue;
                Price toSubtract = Price.ZERO_DOLLAR;
                if (this.breakoutUnits != null) {
                    for (FinanceUnit unit : this.breakoutUnits) {
                        Breakout correspondingReport = this.getCorrespondingBreakout(this.currentCashdrawer, nextDay, unit);
                        CreditEntry entry = cashRec.getCreditEntry(unit);
                        if (entry == null) continue;
                        Price value = entry.getValue();
                        toSubtract = toSubtract.add(value);
                        correspondingReport.actualValue = value;
                    }
                }
                try {
                    DailyReconciliationSummaryReport report = map.get(nextDay);
                    report.applyCashdrawerReconciliation(cashRec);
                    report.applyActualBreakoutAdjustment(toSubtract);
                }
                catch (IllegalArgumentException ex) {
                    OrderMate.LOG.warn("Cannot load cashdrawer reconciliation into summary, results will be zero.", (Throwable)ex);
                }
            }
        }
    }

    private void applyBreakouts(Map<Integer, DailyReconciliationSummaryReport> map, CashDrawer drawer) {
        if (this.breakoutUnits == null) {
            return;
        }
        for (Integer nextDay : map.keySet()) {
            Price toSubtract = Price.ZERO_DOLLAR;
            for (FinanceUnit unit : this.breakoutUnits) {
                Breakout correspondingReport = this.getCorrespondingBreakout(this.currentCashdrawer, nextDay, unit);
                toSubtract = toSubtract.add(correspondingReport.expectedValue);
            }
            DailyReconciliationSummaryReport report = map.get(nextDay);
            report.applyExpectedBreakoutAdjustment(toSubtract);
        }
    }

    public Collection<DailyReconciliationSummaryReport> getRawReportData() {
        ArrayList<DailyReconciliationSummaryReport> toReturn = new ArrayList<DailyReconciliationSummaryReport>();
        for (List<DailyReconciliationSummaryReport> report : this.reports.values()) {
            toReturn.addAll(report);
        }
        return toReturn;
    }

    @Override
    public List<List<String>> getReportData() {
        ArrayList<CashDrawer> drawers = new ArrayList<CashDrawer>(this.reports.keySet());
        Collections.sort(drawers, new Comparator<CashDrawer>(){

            @Override
            public int compare(CashDrawer o1, CashDrawer o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        if (this.breakoutUnits == null) {
            for (CashDrawer drawer : drawers) {
                this.addCashdrawerRowsNoBreakout(rows, drawer);
            }
        } else {
            for (CashDrawer drawer : drawers) {
                this.addCashdrawerRowsWithBreakout(rows, drawer);
            }
        }
        return rows;
    }

    private void addCashdrawerRowsNoBreakout(List<List<String>> rows, CashDrawer drawer) {
        this.addCashdrawerRows(rows, drawer, false);
    }

    private List<List<String>> addCashdrawerRows(List<List<String>> rows, CashDrawer drawer, boolean includeBreakout) {
        List<String> expectedCash = this.makeList(rows, "Expected Cash", drawer);
        List<String> actualCash = this.makeList(rows, "Actual Cash", drawer);
        List<String> expectedCashOut = this.makeList(rows, "Expected Cash Out", drawer);
        List<String> actualCashOut = this.makeList(rows, "Actual Cash Out", drawer);
        List<String> expectedCard = this.makeList(rows, "Expected Card", drawer);
        List<String> actualCard = this.makeList(rows, "Actual Card", drawer);
        List<String> expectedWeb = this.makeList(rows, "Expected Web", drawer);
        List<String> actualWeb = this.makeList(rows, "Actual Web", drawer);
        ArrayList<List<String>> breakoutLists = new ArrayList<List<String>>();
        if (includeBreakout) {
            for (FinanceUnit unit : this.breakoutUnits) {
                breakoutLists.add(this.makeList(rows, "Expected " + unit.getLabel(), drawer));
                breakoutLists.add(this.makeList(rows, "Actual " + unit.getLabel(), drawer));
            }
        }
        List<String> actualPetty = this.makeList(rows, "Petty Cash", drawer);
        List<String> actualTips = this.makeList(rows, "Tips", drawer);
        List<String> actualOverring = this.makeList(rows, "Overring", drawer);
        List<String> variance = this.makeList(rows, "Variance", drawer);
        for (DailyReconciliationSummaryReport report : this.reports.get(drawer)) {
            expectedCash.add(report.getExpectedCash().toString(true));
            actualCash.add(report.getActualCash().toString(true));
            expectedCashOut.add(report.getExpectedCashOut().toString(true));
            actualCashOut.add(report.getActualCashOut().toString(true));
            expectedCard.add(report.getExpectedCard().toString(true));
            actualCard.add(report.getActualCard().toString(true));
            expectedWeb.add(report.getExpectedWeb().toString(true));
            actualWeb.add(report.getActualWeb().toString(true));
            variance.add(report.getVariance().toString(true));
            actualPetty.add(report.getActualPetty().toString(true));
            actualTips.add(report.getActualTips().toString(true));
            actualOverring.add(report.getActualOverring().toString(true));
        }
        return breakoutLists;
    }

    private void addCashdrawerRowsWithBreakout(List<List<String>> rows, CashDrawer drawer) {
        List<List<String>> breakoutLists = this.addCashdrawerRows(rows, drawer, true);
        int count = 0;
        DailyReportIComparator comparator = new DailyReportIComparator();
        for (FinanceUnit unit : this.breakoutUnits) {
            Map<FinanceUnit, List<Breakout>> breakoutMap = this.breakoutReports.get(drawer);
            if (breakoutMap != null) {
                Price totalEx = Price.ZERO_NO_ROUND;
                Price totalAc = Price.ZERO_NO_ROUND;
                List<Breakout> breakoutList = breakoutMap.get(unit);
                Collections.sort(breakoutList, comparator);
                for (Breakout breakout : breakoutList) {
                    breakoutLists.get(2 * count).add(breakout.expectedValue.toString(true));
                    breakoutLists.get(2 * count + 1).add(breakout.actualValue.toString(true));
                    totalEx = totalEx.add(breakout.expectedValue);
                    totalAc = totalAc.add(breakout.actualValue);
                }
                breakoutLists.get(2 * count).add(totalEx.toString(true));
                breakoutLists.get(2 * count + 1).add(totalAc.toString(true));
            }
            ++count;
        }
    }

    private Breakout getCorrespondingBreakout(CashDrawer drawer, Integer dayOfWeek, FinanceUnit type) {
        List<Breakout> breakoutList;
        Breakout theReport = null;
        Map<FinanceUnit, List<Breakout>> unitMap = this.breakoutReports.get(drawer);
        if (unitMap == null) {
            unitMap = new HashMap<FinanceUnit, List<Breakout>>();
            this.breakoutReports.put(drawer, unitMap);
        }
        if ((breakoutList = unitMap.get(type)) == null) {
            breakoutList = new ArrayList<Breakout>();
            unitMap.put(type, breakoutList);
        }
        for (Breakout nextReport : breakoutList) {
            if (!nextReport.dayOfWeek.equals(dayOfWeek) || !nextReport.unit.equals(type)) continue;
            theReport = nextReport;
            break;
        }
        if (theReport == null) {
            theReport = new Breakout(type, drawer, dayOfWeek, Price.ZERO_DOLLAR);
            breakoutList.add(theReport);
        }
        return theReport;
    }

    private List<String> makeList(List<List<String>> rows, String rowTitle, CashDrawer drawer) {
        ArrayList<String> list = new ArrayList<String>();
        if (drawer == null) {
            list.add("Total");
        } else {
            list.add(drawer.getLabel());
        }
        list.add(rowTitle);
        rows.add(list);
        return list;
    }

    private List<DailyReconciliationSummaryReport> getTotals(Collection<List<DailyReconciliationSummaryReport>> toConsolidate) {
        ArrayList<DailyReconciliationSummaryReport> totalsList = new ArrayList<DailyReconciliationSummaryReport>();
        LinkedHashMap<Integer, DailyReconciliationSummaryReport> totalMap = new LinkedHashMap<Integer, DailyReconciliationSummaryReport>();
        for (List<DailyReconciliationSummaryReport> cashdrawerReports : toConsolidate) {
            for (DailyReconciliationSummaryReport report : cashdrawerReports) {
                if (totalMap.get(report.getDayOfWeek()) == null) {
                    totalMap.put(report.getDayOfWeek(), new DailyReconciliationSummaryReport(report.getDayOfWeek(), null));
                    totalsList.add((DailyReconciliationSummaryReport)totalMap.get(report.getDayOfWeek()));
                }
                ((DailyReconciliationSummaryReport)totalMap.get(report.getDayOfWeek())).add(report);
            }
        }
        if (this.breakoutUnits != null) {
            for (FinanceUnit unit : this.breakoutUnits) {
                for (int i = 1; i < 8; ++i) {
                    Breakout totalBreakout = this.getCorrespondingBreakout(null, i, unit);
                    for (Map<FinanceUnit, List<Breakout>> nextBreakoutMap : this.breakoutReports.values()) {
                        for (Breakout nextBreakout : nextBreakoutMap.get(unit)) {
                            if (nextBreakout.drawer == null || nextBreakout.dayOfWeek != i) continue;
                            totalBreakout.actualValue = totalBreakout.actualValue.add(nextBreakout.actualValue);
                            totalBreakout.expectedValue = totalBreakout.expectedValue.add(nextBreakout.expectedValue);
                        }
                    }
                }
            }
        }
        return totalsList;
    }

    @Override
    protected DailyReconciliationSummaryReport createEmptyReport(Integer theDayOfWeek) {
        DailyReconciliationSummaryReport report = new DailyReconciliationSummaryReport(theDayOfWeek, this.currentCashdrawer);
        return report;
    }

    @Override
    protected String getPrimaryColumnName() {
        return "Type";
    }

    @Override
    public List<String> getColumnNames() {
        List<String> names = super.getColumnNames();
        names.add(0, "Cashdrawer");
        return names;
    }

    private Map<CashDrawer, Map<FinanceUnit, List<Breakout>>> getBreakouts() {
        ReportProperty property = ReportProperty.find(ReportGroup.DailySummary, BREAKOUT);
        String breakoutName = property.getStringValue(null);
        if (breakoutName == null || breakoutName.isEmpty()) {
            return null;
        }
        List<String> labels = StringUtils.splitToList(breakoutName, ",");
        this.breakoutUnits = new ArrayList<FinanceUnit>(labels.size());
        for (String string : labels) {
            FinanceUnit breakoutUnit = FinanceUnit.getUnitForName(string);
            if (breakoutUnit == null || !FinanceUnit.CREDIT_TYPE.toString().equals(breakoutUnit.getType())) {
                OrderMate.LOG.warn("Cannot breakout anything but credit types. Development required.");
                continue;
            }
            this.breakoutUnits.add(breakoutUnit);
        }
        if (this.breakoutUnits == null || this.breakoutUnits.isEmpty()) {
            OrderMate.LOG.warn("No finance unit breakouts. Cannot find finance unit for name:" + breakoutName);
            return null;
        }
        ArrayList<Breakout> breakoutList = new ArrayList<Breakout>();
        for (FinanceUnit unit : this.breakoutUnits) {
            List<DailyReconciliationSummaryReport> breakoutReports = this.searcher.getBreakoutReports(unit);
            for (DailyReconciliationSummaryReport report : breakoutReports) {
                breakoutList.add(new Breakout(unit, report.getCashDrawer(), report.getDayOfWeek(), report.getExpectedCard()));
            }
        }
        HashMap<CashDrawer, Map<FinanceUnit, List<Breakout>>> hashMap = new HashMap<CashDrawer, Map<FinanceUnit, List<Breakout>>>();
        for (Breakout nextBreakout : breakoutList) {
            if (!hashMap.containsKey(nextBreakout.drawer)) {
                hashMap.put(nextBreakout.drawer, new HashMap());
            }
            if (!((Map)hashMap.get(nextBreakout.drawer)).containsKey(nextBreakout.unit)) {
                ((Map)hashMap.get(nextBreakout.drawer)).put(nextBreakout.unit, new ArrayList());
            }
            ((List)((Map)hashMap.get(nextBreakout.drawer)).get(nextBreakout.unit)).add(nextBreakout);
        }
        return hashMap;
    }

    private class Breakout
    implements DailyReportI {
        CashDrawer drawer;
        Price expectedValue;
        Price actualValue;
        FinanceUnit unit;
        Integer dayOfWeek;

        public Breakout(FinanceUnit theUnit, CashDrawer cashDrawer, Integer theDayOfWeek, Price expected) {
            this.drawer = cashDrawer;
            this.unit = theUnit;
            this.expectedValue = expected;
            this.actualValue = Price.ZERO_DOLLAR;
            this.dayOfWeek = theDayOfWeek;
        }

        @Override
        public Integer getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public void add(DailyReportI otherReport) {
            throw new IllegalStateException("Not implemented");
        }
    }
}

