/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.dailysummary.AbstractDailyReport;
import ordermate.database.reports.dailysummary.DailyReportI;
import ordermate.database.reports.dailysummary.DailySalesSummaryReportProperties;

public class DailySalesSummaryReport
extends AbstractDailyReport
implements Cloneable {
    public static final Props Properties = new Props();
    private String dayPart;
    private Reference<SalesLocation> location;
    private String label;
    private Price patronSales;
    private Price patronSalesBeforeAdj;
    private Price salesEx;
    private Price tax;
    private Price discounts;
    private Price discountsEx;
    private Price surcharges;
    private Price surchargesEx;
    private Price refunds;
    private Integer numPatrons;
    private BigDecimal volume;

    public DailySalesSummaryReport() {
        this.location = this.createReference(DailySalesSummaryReport.Properties.LOCATION);
        this.discountsEx = Price.ZERO_DOLLAR;
        this.surchargesEx = Price.ZERO_DOLLAR;
        this.volume = BigDecimal.valueOf(0L);
    }

    public DailySalesSummaryReport(Integer theDayOfWeek, SalesLocation location, DayPart theDayPart, String theLabel) {
        this(theDayOfWeek, location, theDayPart, theLabel, Price.ZERO_NO_ROUND, Price.ZERO_NO_ROUND, Price.ZERO_NO_ROUND, Price.ZERO_NO_ROUND, Price.ZERO_NO_ROUND, Price.ZERO_NO_ROUND, Price.ZERO_NO_ROUND, null, null);
    }

    public DailySalesSummaryReport(Integer theDayOfWeek, SalesLocation location, DayPart theDayPart, String theLabel, Price salesTotal, Price taxTotal, Price discountsTotal, Price discountsExTotal, Price surchargesTotal, Price surchargesExTotal, Price refundsTotal, Integer numPatronsTotal, BigDecimal volumeTotal) {
        super(theDayOfWeek);
        this.location = this.createReference(DailySalesSummaryReport.Properties.LOCATION);
        this.discountsEx = Price.ZERO_DOLLAR;
        this.surchargesEx = Price.ZERO_DOLLAR;
        this.volume = BigDecimal.valueOf(0L);
        this.setLocation(location);
        this.dayPart = theDayPart == null ? null : theDayPart.getLabel();
        this.salesEx = salesTotal;
        this.label = theLabel;
        this.tax = taxTotal;
        this.refunds = refundsTotal;
        this.discounts = discountsTotal;
        this.discountsEx = discountsExTotal;
        this.surcharges = surchargesTotal;
        this.surchargesEx = surchargesExTotal;
        this.numPatrons = numPatronsTotal;
        this.patronSales = null;
        this.patronSalesBeforeAdj = null;
        this.setVolume(volumeTotal);
    }

    public DailySalesSummaryReport(DailySalesSummaryReport report) {
        super(report.getDayOfWeek());
        this.location = this.createReference(DailySalesSummaryReport.Properties.LOCATION);
        this.discountsEx = Price.ZERO_DOLLAR;
        this.surchargesEx = Price.ZERO_DOLLAR;
        this.volume = BigDecimal.valueOf(0L);
        this.setLocation(report.getLocation());
        this.dayPart = report.dayPart;
        this.salesEx = report.salesEx;
        this.label = report.label;
        this.tax = report.tax;
        this.refunds = report.refunds;
        this.discounts = report.discounts;
        this.discountsEx = report.discountsEx;
        this.surcharges = report.getSurcharges();
        this.surchargesEx = report.getSurchargesEx();
        this.numPatrons = report.numPatrons;
        this.patronSales = report.patronSales;
        this.patronSalesBeforeAdj = report.patronSalesBeforeAdj;
        this.volume = report.volume;
    }

    @Override
    public void add(DailyReportI otherReport) {
        DailySalesSummaryReport other = (DailySalesSummaryReport)otherReport;
        this.salesEx = this.salesEx.add(other.getSalesEx());
        this.tax = this.tax.add(other.getTax());
        if (other.numPatrons != null) {
            if (this.numPatrons == null) {
                this.numPatrons = 0;
            }
            this.numPatrons = this.numPatrons + other.getNumPatrons();
        }
        this.discounts = this.discounts.add(other.getDiscounts());
        this.discountsEx = this.getDiscountsEx().add(other.getDiscountsEx());
        this.surcharges = this.getSurcharges().add(other.getSurcharges());
        this.surchargesEx = this.getSurchargesEx().add(other.getSurchargesEx());
        this.refunds = this.refunds.add(other.getRefunds());
        this.addPatronSales(other);
        this.addPatronSalesBeforeAdj(other);
        this.volume = BigDecimal.valueOf(this.volume.doubleValue() + other.volume.doubleValue());
    }

    private void addPatronSales(DailySalesSummaryReport other) {
        if (other.patronSales != null) {
            if (this.patronSales == null) {
                this.patronSales = Price.ZERO_DOLLAR;
            }
            this.patronSales = this.sumPatronSales(other, true);
        }
    }

    private void addPatronSalesBeforeAdj(DailySalesSummaryReport other) {
        if (other.patronSalesBeforeAdj != null) {
            if (this.patronSalesBeforeAdj == null) {
                this.patronSalesBeforeAdj = Price.ZERO_DOLLAR;
            }
            this.patronSalesBeforeAdj = this.sumPatronSales(other, false);
        }
    }

    private Price sumPatronSales(DailySalesSummaryReport otherReport, boolean afterAdjustment) {
        return this.getPatronSalesForSum(afterAdjustment).add(otherReport.getPatronSalesForSum(afterAdjustment));
    }

    private Price getPatronSalesForSum(boolean afterAdjustment) {
        List<String> categoriesToExclude;
        String excludeCategories = DailySalesSummaryReportProperties.getExcludeCategoryDollarPerHead();
        if (!StringUtils.isEmpty(excludeCategories) && (categoriesToExclude = StringUtils.splitToList(excludeCategories, ",")).contains(this.getLabel())) {
            return Price.ZERO_DOLLAR;
        }
        return afterAdjustment ? this.patronSales : this.patronSalesBeforeAdj;
    }

    public void subtract(DailySalesSummaryReport other) {
        this.salesEx = this.salesEx.subtract(other.getSalesEx());
        this.tax = this.tax.subtract(other.getTax());
        if (other.numPatrons != null && this.numPatrons == null) {
            this.numPatrons = 0;
        }
        this.discounts = this.discounts.subtract(other.getDiscounts());
        this.discountsEx = this.getDiscountsEx().subtract(other.getDiscountsEx());
        this.surcharges = this.surcharges.subtract(other.getSurcharges());
        this.surchargesEx = this.surchargesEx.subtract(other.getSurchargesEx());
        this.refunds = this.refunds.subtract(other.getRefunds());
        if (other.patronSales != null && this.patronSales == null) {
            this.patronSales = Price.ZERO_DOLLAR;
        }
        if (other.patronSalesBeforeAdj != null && this.patronSalesBeforeAdj == null) {
            this.patronSalesBeforeAdj = Price.ZERO_DOLLAR;
        }
        this.volume = BigDecimal.valueOf(this.volume.doubleValue() - other.volume.doubleValue());
    }

    public final String getDayPart() {
        return this.dayPart;
    }

    protected final void setDayPart(String value) {
        this.dayPart = value;
    }

    public SalesLocation getLocation() {
        return this.location.get();
    }

    protected void setLocation(SalesLocation value) {
        this.location.set(value);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public Price getSalesEx() {
        return this.salesEx;
    }

    protected void setSalesEx(Price value) {
        this.salesEx = value;
    }

    public Price getTax() {
        return this.tax;
    }

    protected void setTax(Price value) {
        this.tax = value;
    }

    public Price getDiscounts() {
        return this.discounts;
    }

    protected void setDiscounts(Price value) {
        this.discounts = value;
    }

    public Price getDiscountsEx() {
        return this.discountsEx == null ? Price.ZERO_DOLLAR : this.discountsEx;
    }

    protected void setDiscountsEx(Price value) {
        this.discountsEx = value;
    }

    public Price getSurcharges() {
        return this.surcharges;
    }

    protected void setSurcharges(Price value) {
        this.surcharges = value;
    }

    public Price getSurchargesEx() {
        return this.surchargesEx == null ? Price.ZERO_DOLLAR : this.surchargesEx;
    }

    protected void setSurchargesEx(Price value) {
        this.surchargesEx = value;
    }

    public Price getRefunds() {
        return this.refunds;
    }

    protected void setRefunds(Price value) {
        this.refunds = value;
    }

    public Integer getNumPatrons() {
        return this.numPatrons;
    }

    public void setNumPatrons(Integer value) {
        this.numPatrons = value;
    }

    public Price getSalesInc() {
        return this.salesEx.add(this.tax);
    }

    public Price getPatronSales() {
        return this.patronSales;
    }

    public void setPatronSales(Price value) {
        this.patronSales = value;
    }

    public Price getPatronSalesBeforeAdj() {
        return this.patronSalesBeforeAdj;
    }

    public void setPatronSalesBeforeAdj(Price value) {
        this.patronSalesBeforeAdj = value;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public void setVolume(BigDecimal value) {
        this.volume = value == null ? BigDecimal.valueOf(0L) : value;
    }

    public Price getDollarsPerHead() {
        boolean dollarPerHeadBeforeAdj = DailySalesSummaryReportProperties.isDollarPerHeaBeforeAdjustment();
        return this.getDollarPerHead(dollarPerHeadBeforeAdj ? this.patronSalesBeforeAdj : this.patronSales);
    }

    private Price getDollarPerHead(Price yourPatronSales) {
        Price toUse = yourPatronSales;
        if (yourPatronSales == null) {
            toUse = this.getSalesEx();
        }
        return this.numPatrons == 0 ? Price.ZERO_DOLLAR : toUse.divide(this.numPatrons);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class Props
    extends AbstractDailyReport.Props {
        public PropertiedObject.Property<String> DAY_PART;
        public PropertiedObject.Property<SalesLocation> LOCATION;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<Price> SALES_EX;
        public PropertiedObject.Property<BigDecimal> VOLUME;
        public PropertiedObject.Property<Price> TAX;
        public PropertiedObject.Property<Price> DISCOUNTS;
        public PropertiedObject.Property<Price> DISCOUNTS_EX;
        public PropertiedObject.Property<Price> SURCHARGES;
        public PropertiedObject.Property<Price> SURCHARGES_EX;
        public PropertiedObject.Property<Price> REFUNDS;
        public PropertiedObject.Property<Integer> NUM_PATRONS;
        public PropertiedObject.Property<Price> PATRON_SALES;
        public PropertiedObject.Property<Price> PATRON_SALES_BEFORE_ADJ;
        public PersistentObject.DerivedProperty<Price> DOLLARS_PER_HEAD = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailySalesSummaryReport.class), "dollarsPerHead");
        public PersistentObject.DerivedProperty<Price> SALES_INC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailySalesSummaryReport.class), "salesInc");
    }
}

