/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.dailysummary.AbstractDailySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.database.reports.dailysummary.DailySalesSummaryReportProperties;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportByAccountType;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportType;
import ordermate.internationalization.Internationalization;

public class DailySalesSummaryReportCompiler
extends AbstractDailySummaryReportCompiler<DailySalesSummaryReport> {
    private static final String EX_TAX = "*";
    private static final String EX_ADJ = "^";
    private DayPart dayPart;
    private SalesLocation location;
    private DailySummaryReportType reportType;
    private List<DailyPatronsReport> patrons = null;
    private Map<String, List<DailySalesSummaryReport>> reportMap;
    private String currentLabel;
    private List<DailySalesSummaryReport> totalSales;

    public DailySalesSummaryReportCompiler(SalesLocation location, DayPart part, List<DailySalesSummaryReport> reports, DailySummaryReportType theReportType, List<DailyPatronsReport> patrons) {
        this.dayPart = part;
        this.reportType = theReportType;
        this.location = location;
        this.patrons = patrons;
        this.reportMap = this.loadLabelMap(reports);
    }

    @Override
    public List<List<String>> getReportData() {
        this.currentLabel = "columnarTotal";
        List<DailySalesSummaryReport> columnarTotals = this.createColumnarTotalsReports(this.reportMap);
        ArrayList<String> labelList = new ArrayList<String>(this.reportMap.keySet());
        Collections.sort(labelList);
        return this.makeSummaryRows(labelList, this.reportMap, columnarTotals);
    }

    private Map<String, List<DailySalesSummaryReport>> loadLabelMap(List<DailySalesSummaryReport> reportList) {
        HashMap labelMap = new HashMap();
        for (DailySalesSummaryReport dailySalesSummaryReport : reportList) {
            if (!labelMap.containsKey(dailySalesSummaryReport.getLabel())) {
                labelMap.put(dailySalesSummaryReport.getLabel(), new HashMap());
            }
            if (this.location != null && !this.location.equals(dailySalesSummaryReport.getLocation()) || this.dayPart != null && !this.dayPart.getLabel().equals(dailySalesSummaryReport.getDayPart())) continue;
            if (((Map)labelMap.get(dailySalesSummaryReport.getLabel())).containsKey(dailySalesSummaryReport.getDayOfWeek())) {
                ((DailySalesSummaryReport)((Map)labelMap.get(dailySalesSummaryReport.getLabel())).get(dailySalesSummaryReport.getDayOfWeek())).add(dailySalesSummaryReport);
                continue;
            }
            ((Map)labelMap.get(dailySalesSummaryReport.getLabel())).put(dailySalesSummaryReport.getDayOfWeek(), new DailySalesSummaryReport(dailySalesSummaryReport));
        }
        Map nextMap = null;
        Iterator iterator = labelMap.keySet().iterator();
        while (iterator.hasNext()) {
            String label;
            this.currentLabel = label = (String)iterator.next();
            nextMap = (Map)labelMap.get(label);
            this.insertMissingReports(nextMap);
            this.addRowTotalsReport(nextMap);
        }
        this.currentLabel = null;
        this.updateNumPatrons(nextMap);
        HashMap<String, List<DailySalesSummaryReport>> hashMap = new HashMap<String, List<DailySalesSummaryReport>>();
        for (String nextLabel : labelMap.keySet()) {
            ArrayList list = new ArrayList(((Map)labelMap.get(nextLabel)).values());
            this.sortListByDayOfWeek(list);
            hashMap.put(nextLabel, list);
        }
        return hashMap;
    }

    protected void updateNumPatrons(Map<Integer, DailySalesSummaryReport> toUpdate) {
        if (this.patrons == null || toUpdate == null) {
            return;
        }
        int total = 0;
        for (DailyPatronsReport patronReport : this.patrons) {
            DailySalesSummaryReport nextReport = toUpdate.get(patronReport.getDayOfWeek());
            total += patronReport.getNumPatrons();
            if (nextReport == null) continue;
            nextReport.setNumPatrons(patronReport.getNumPatrons());
        }
        if (toUpdate != null && toUpdate.containsKey(null)) {
            toUpdate.get(null).setNumPatrons(total);
        }
    }

    private List<List<String>> makeSummaryRows(List<String> labelList, Map<String, List<DailySalesSummaryReport>> reportsMap, List<DailySalesSummaryReport> columnarTotals) {
        boolean showNetSales;
        boolean adjustmentsEx = DailySalesSummaryReportProperties.isAdjustmentsEx();
        boolean salesExBeforeAdjustments = DailySalesSummaryReportProperties.isSalesExBeforeAdjustments();
        boolean showAdjustmentsIncAndTax = DailySalesSummaryReportProperties.isShowAdjustmentsIncAndTax();
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        Map<String, List<DailySalesSummaryReport>> breakouts = this.getBreakouts(reportsMap);
        for (String nextLabel : labelList) {
            this.makeSummaryRows(nextLabel, reportsMap.get(nextLabel), columnarTotals, rows);
        }
        ArrayList<String> patronRow = new ArrayList<String>();
        patronRow.add(Internationalization.getLiteralFor("COVERS"));
        ArrayList<String> dollarsRow = new ArrayList<String>();
        dollarsRow.add(Internationalization.getLiteralFor("DOLLAR_SIGN") + " / Head");
        ArrayList<String> salesExRow = new ArrayList<String>();
        String sales = "Sales Ex Tax" + (salesExBeforeAdjustments ? "" : EX_ADJ);
        salesExRow.add(sales);
        ArrayList<String> taxRow = new ArrayList<String>();
        taxRow.add("Tax");
        ArrayList<String> salesIncRow = new ArrayList<String>();
        salesIncRow.add("Sales Inc Tax^");
        ArrayList<String> discountsRow = new ArrayList<String>();
        discountsRow.add("Discounts");
        ArrayList<String> surchargesRow = new ArrayList<String>();
        surchargesRow.add("Surcharges");
        ArrayList<String> netSalesRow = new ArrayList<String>();
        netSalesRow.add("Net Sales");
        ArrayList<String> discountsExRow = null;
        ArrayList<String> surchargesExRow = null;
        ArrayList<String> discountTax = null;
        ArrayList<String> surchargeTax = null;
        ArrayList<String> unadjustedTax = null;
        if (adjustmentsEx) {
            discountsExRow = new ArrayList<String>();
            discountsExRow.add("Discounts Ex Tax");
            surchargesExRow = new ArrayList<String>();
            surchargesExRow.add("Surcharges Ex Tax");
            if (showAdjustmentsIncAndTax) {
                discountTax = new ArrayList<String>();
                discountTax.add("Discount Tax");
                surchargeTax = new ArrayList<String>();
                surchargeTax.add("Surcharge Tax");
                unadjustedTax = new ArrayList<String>();
                unadjustedTax.add("Unadjusted Tax");
            }
        }
        ArrayList<String> volumesRow = new ArrayList<String>();
        volumesRow.add("Volume");
        List<DailySalesSummaryReport> breakoutTotals = this.makeBreakoutTotalList(breakouts, columnarTotals);
        rows.add(volumesRow);
        rows.add(salesExRow);
        if (showAdjustmentsIncAndTax) {
            rows.add(discountsRow);
            rows.add(surchargesRow);
        }
        if (adjustmentsEx) {
            rows.add(discountsExRow);
            rows.add(surchargesExRow);
            if (showAdjustmentsIncAndTax) {
                rows.add(unadjustedTax);
                rows.add(discountTax);
                rows.add(surchargeTax);
            }
        }
        if (showNetSales = DailySalesSummaryReportProperties.isShowNetSales()) {
            rows.add(netSalesRow);
        }
        rows.add(taxRow);
        rows.add(salesIncRow);
        boolean hasPatrons = false;
        this.totalSales = new ArrayList<DailySalesSummaryReport>();
        for (DailySalesSummaryReport report : columnarTotals) {
            salesExRow.add(this.getSalesAmountData(salesExBeforeAdjustments, adjustmentsEx, report));
            netSalesRow.add(this.getNetSalesData(report));
            taxRow.add(report.getTax().toString(true));
            salesIncRow.add(report.getSalesInc().toString(true));
            if (showAdjustmentsIncAndTax) {
                discountsRow.add(report.getDiscounts().toString(true));
                surchargesRow.add(report.getSurcharges().negate().toString(true));
            }
            if (adjustmentsEx) {
                discountsExRow.add(report.getDiscountsEx().toString(true));
                surchargesExRow.add(report.getSurchargesEx().negate().toString(true));
                if (showAdjustmentsIncAndTax) {
                    discountTax.add(report.getDiscounts().subtract(report.getDiscountsEx()).toString(true));
                    surchargeTax.add(report.getSurcharges().subtract(report.getSurchargesEx()).negate().toString(true));
                    unadjustedTax.add(report.getTax().add(report.getDiscounts().subtract(report.getDiscountsEx())).add(report.getSurcharges().subtract(report.getSurchargesEx())).toString());
                }
            }
            volumesRow.add(this.getVolumeFormat().format(report.getVolume()));
            if (breakouts != null) continue;
            this.totalSales.add(new DailySalesSummaryReport(report));
        }
        if (breakouts != null) {
            ArrayList<String> breakoutTotalRow = new ArrayList<String>();
            StringBuilder breakoutLabel = new StringBuilder("Sales Ex -");
            for (String nextKey : breakouts.keySet()) {
                breakoutLabel.append(" ").append(nextKey);
            }
            breakoutTotalRow.add(breakoutLabel.toString());
            for (DailySalesSummaryReport report : breakoutTotals) {
                breakoutTotalRow.add(report.getSalesEx().toString(true));
                this.totalSales.add(new DailySalesSummaryReport(report));
            }
            rows.add(breakoutTotalRow);
        }
        List<DailySalesSummaryReport> totalsToUse = breakoutTotals != null ? breakoutTotals : columnarTotals;
        for (DailySalesSummaryReport report : totalsToUse) {
            if (report.getNumPatrons() != null) {
                int numPatrons = report.getNumPatrons();
                hasPatrons = true;
                patronRow.add(String.valueOf(numPatrons));
                Price price = report.getDollarsPerHead();
                dollarsRow.add(price.toString(true));
                continue;
            }
            patronRow.add(String.valueOf(0));
            dollarsRow.add(Price.ZERO_DOLLAR.toString(true));
        }
        if (hasPatrons) {
            rows.add(patronRow);
            rows.add(dollarsRow);
        }
        return rows;
    }

    private String getSalesAmountData(boolean salesBeforeAdjustments, boolean adjustmentsEx, DailySalesSummaryReport report) {
        if (salesBeforeAdjustments) {
            if (adjustmentsEx) {
                return report.getSalesEx().add(report.getDiscountsEx()).add(report.getSurchargesEx()).toString(true);
            }
            return report.getSalesEx().add(report.getDiscounts()).add(report.getSurcharges()).toString(true);
        }
        return report.getSalesEx().toString(true);
    }

    private String getNetSalesData(DailySalesSummaryReport report) {
        return report.getSalesEx().toString(true);
    }

    private void makeSummaryRows(String label, List<DailySalesSummaryReport> theReportList, List<DailySalesSummaryReport> columnarTotals, List<List<String>> rows) {
        boolean adjustmentsEx = DailySalesSummaryReportProperties.isAdjustmentsEx();
        boolean salesExBeforeAdjustments = DailySalesSummaryReportProperties.isSalesExBeforeAdjustments();
        boolean showAdjustmentsIncAndTax = DailySalesSummaryReportProperties.isShowAdjustmentsIncAndTax();
        ArrayList<String> salesRow = new ArrayList<String>();
        salesRow.add(label + " Sales" + EX_TAX + (salesExBeforeAdjustments ? "" : EX_ADJ));
        rows.add(salesRow);
        boolean requiresDetail = this.reportType.requiresDetailPerSection();
        ArrayList<String> percSalesRow = new ArrayList<String>();
        ArrayList<String> discountsRow = new ArrayList<String>();
        ArrayList<String> discountsExRow = new ArrayList<String>();
        ArrayList<String> discountsTax = new ArrayList<String>();
        ArrayList<String> surchargesRow = new ArrayList<String>();
        ArrayList<String> surchargesExRow = new ArrayList<String>();
        ArrayList<String> surchargesTax = new ArrayList<String>();
        ArrayList<String> unadjustedTax = new ArrayList<String>();
        ArrayList<String> refundsRow = new ArrayList<String>();
        ArrayList<String> volumesRow = new ArrayList<String>();
        if (requiresDetail) {
            percSalesRow.add(label + " %");
            discountsRow.add(label + " Disc");
            surchargesRow.add(label + " Sur");
            refundsRow.add(label + " Ref");
            volumesRow.add(label + " Volume");
            rows.add(percSalesRow);
            if (showAdjustmentsIncAndTax) {
                rows.add(discountsRow);
                rows.add(surchargesRow);
            }
            if (adjustmentsEx) {
                discountsExRow.add(label + " Disc Ex");
                surchargesExRow.add(label + " Sur Ex");
                rows.add(discountsExRow);
                rows.add(surchargesExRow);
                if (showAdjustmentsIncAndTax) {
                    discountsTax.add(label + " Disc Tax");
                    surchargesTax.add(label + " Sur Tax");
                    unadjustedTax.add(label + " Unadjusted Tax");
                    rows.add(unadjustedTax);
                    rows.add(discountsTax);
                    rows.add(surchargesTax);
                }
            }
            rows.add(refundsRow);
            rows.add(volumesRow);
        }
        NumberFormat percFormat = NumberFormat.getPercentInstance();
        NumberFormat volumeFormat = this.getVolumeFormat();
        for (int i = 0; i < theReportList.size(); ++i) {
            DailySalesSummaryReport report = theReportList.get(i);
            DailySalesSummaryReport total = columnarTotals.get(i);
            salesRow.add(this.getSalesAmountData(salesExBeforeAdjustments, adjustmentsEx, report));
            if (!requiresDetail) continue;
            percSalesRow.add(Price.ZERO_DOLLAR.equals(total.getSalesEx()) ? "0%" : percFormat.format(report.getSalesEx().doubleValue() / total.getSalesEx().doubleValue()));
            if (showAdjustmentsIncAndTax) {
                discountsRow.add(report.getDiscounts().toString(true));
                surchargesRow.add(report.getSurcharges().toString(true));
            }
            if (adjustmentsEx) {
                discountsExRow.add(report.getDiscountsEx().toString(true));
                surchargesExRow.add(report.getSurchargesEx().toString(true));
                if (showAdjustmentsIncAndTax) {
                    Price discTax = report.getDiscounts().subtract(report.getDiscountsEx());
                    discountsTax.add(discTax.toString(true));
                    Price surTax = report.getSurcharges().subtract(report.getSurchargesEx());
                    surchargesTax.add(surTax.negate().toString(true));
                    unadjustedTax.add(report.getTax().add(discTax).add(surTax).toString(true));
                }
            }
            refundsRow.add(report.getRefunds().toString(true));
            volumesRow.add(volumeFormat.format(report.getVolume()));
        }
    }

    private NumberFormat getVolumeFormat() {
        NumberFormat volumeFormat = NumberFormat.getNumberInstance();
        volumeFormat.setMaximumFractionDigits(3);
        volumeFormat.setMinimumFractionDigits(0);
        return volumeFormat;
    }

    @Override
    protected DailySalesSummaryReport createEmptyReport(Integer theDayOfWeek) {
        return new DailySalesSummaryReport(theDayOfWeek, this.location, this.dayPart, this.currentLabel);
    }

    @Override
    protected String getPrimaryColumnName() {
        return this.dayPart == null ? "Day Total" : this.dayPart.getLabel();
    }

    private Map<String, List<DailySalesSummaryReport>> getBreakouts(Map<String, List<DailySalesSummaryReport>> reportsMap) {
        String breakoutProperty = this.reportType instanceof DailySummaryReportByAccountType ? DailySalesSummaryReportProperties.getBreakoutAccountType() : DailySalesSummaryReportProperties.getBreakoutCategory();
        List<String> breakouts = StringUtils.splitToList(breakoutProperty, ",");
        if (breakouts != null && !breakouts.isEmpty() && !breakouts.get(0).trim().isEmpty()) {
            LinkedHashMap<String, List<DailySalesSummaryReport>> breakoutMap = new LinkedHashMap<String, List<DailySalesSummaryReport>>();
            for (String nextBreakout : breakouts) {
                List<DailySalesSummaryReport> reports = reportsMap.get(nextBreakout);
                if (reports == null) continue;
                breakoutMap.put(nextBreakout, reports);
            }
            if (breakoutMap.isEmpty()) {
                breakoutMap = null;
            }
            return breakoutMap;
        }
        return null;
    }

    private List<DailySalesSummaryReport> makeBreakoutTotalList(Map<String, List<DailySalesSummaryReport>> breakoutMap, List<DailySalesSummaryReport> columnarTotals) {
        if (breakoutMap == null) {
            return null;
        }
        ArrayList<DailySalesSummaryReport> breakoutTotals = new ArrayList<DailySalesSummaryReport>(breakoutMap.size());
        String label = "Breakouts";
        for (int i = 0; i < columnarTotals.size(); ++i) {
            DailySalesSummaryReport totalReport = columnarTotals.get(i);
            DailySalesSummaryReport breakoutTotalReport = new DailySalesSummaryReport(i, this.location, this.dayPart, label, totalReport.getSalesEx(), totalReport.getTax(), totalReport.getDiscounts(), totalReport.getDiscountsEx(), totalReport.getSurcharges(), totalReport.getSurchargesEx(), totalReport.getRefunds(), totalReport.getNumPatrons(), totalReport.getVolume());
            breakoutTotalReport.setPatronSales(totalReport.getPatronSales());
            breakoutTotalReport.setPatronSalesBeforeAdj(totalReport.getPatronSalesBeforeAdj());
            breakoutTotals.add(breakoutTotalReport);
        }
        breakoutTotals.add(new DailySalesSummaryReport(null, this.location, this.dayPart, label));
        for (List<DailySalesSummaryReport> nextBunch : breakoutMap.values()) {
            for (int i = 0; i < nextBunch.size(); ++i) {
                ((DailySalesSummaryReport)breakoutTotals.get(i)).subtract(nextBunch.get(i));
            }
        }
        return breakoutTotals;
    }

    public List<DailySalesSummaryReport> getTotalSales() {
        return this.totalSales;
    }
}

