/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.dailysummary.AbstractDailySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyVoucherSummaryReport;
import ordermate.internationalization.Internationalization;

public class DailyVoucherSummaryReportCompiler
extends AbstractDailySummaryReportCompiler<DailyVoucherSummaryReport> {
    private List<List<String>> rows;

    public DailyVoucherSummaryReportCompiler(List<DailyVoucherSummaryReport> topupsReport, List<DailyVoucherSummaryReport> redeemsReport, List<DailyVoucherSummaryReport> topupReversalsReport, List<DailyVoucherSummaryReport> redeemReversalsReport) {
        Map<Integer, DailyVoucherSummaryReport> topupsMap = this.mapByDayOfWeek(topupsReport);
        this.insertMissingReports(topupsMap);
        Map<Integer, DailyVoucherSummaryReport> topupReversalsMap = this.mapByDayOfWeek(topupReversalsReport);
        this.addReports(topupsMap, topupReversalsMap);
        Map<Integer, DailyVoucherSummaryReport> redeemsMap = this.mapByDayOfWeek(redeemsReport);
        this.addReports(topupsMap, redeemsMap);
        Map<Integer, DailyVoucherSummaryReport> redeemReversalsMap = this.mapByDayOfWeek(redeemReversalsReport);
        this.addReports(topupsMap, redeemReversalsMap);
        this.addRowTotalsReport(topupsMap);
        ArrayList<DailyVoucherSummaryReport> sortedList = new ArrayList<DailyVoucherSummaryReport>(topupsMap.values());
        this.sortListByDayOfWeek(sortedList);
        this.makeSummaryData(sortedList);
    }

    private void addReports(Map<Integer, DailyVoucherSummaryReport> map1, Map<Integer, DailyVoucherSummaryReport> map2) {
        for (Integer nextDay : map1.keySet()) {
            DailyVoucherSummaryReport report = map2.get(nextDay);
            if (report == null) continue;
            map1.get(nextDay).add(report);
        }
    }

    @Override
    protected DailyVoucherSummaryReport createEmptyReport(Integer theDayOfWeek) {
        return new DailyVoucherSummaryReport(theDayOfWeek);
    }

    @Override
    protected String getPrimaryColumnName() {
        return "Activity";
    }

    private void makeSummaryData(List<DailyVoucherSummaryReport> sortedReports) {
        this.rows = new ArrayList<List<String>>();
        ArrayList<String> topups = new ArrayList<String>();
        topups.add(Internationalization.getLiteralFor("TOPUPS"));
        ArrayList<String> topupReversals = new ArrayList<String>();
        topupReversals.add(Internationalization.getLiteralFor("TOPUP_REVERSALS"));
        ArrayList<String> redeems = new ArrayList<String>();
        redeems.add(Internationalization.getLiteralFor("REDEEMS"));
        ArrayList<String> redeemReversals = new ArrayList<String>();
        redeemReversals.add(Internationalization.getLiteralFor("REDEEM_REVERSALS"));
        ArrayList<String> voucherTotals = new ArrayList<String>();
        voucherTotals.add(Internationalization.getLiteralFor("TOTAL"));
        for (DailyVoucherSummaryReport report : sortedReports) {
            topups.add(report.getTopups().toString(true));
            topupReversals.add(report.getTopupReversals().toString(true));
            redeems.add(report.getRedeems().toString(true));
            redeemReversals.add(report.getRedeemReversals().toString(true));
            Price totalDaily = report.getTopups().add(report.getTopupReversals()).add(report.getRedeems()).add(report.getRedeemReversals());
            voucherTotals.add(totalDaily.toString());
        }
        this.rows.add(topups);
        this.rows.add(topupReversals);
        this.rows.add(redeems);
        this.rows.add(redeemReversals);
        this.rows.add(voucherTotals);
    }

    @Override
    public List<List<String>> getReportData() {
        return this.rows;
    }
}

