/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary;

import au.com.ordermate.search.offset.DateOffsetFunction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.reports.periodstock.PeriodStockAreaReport;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockTake;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class StockSummaryReportCompiler {
    private List<PeriodStockAreaReportItem> reportList = new ArrayList<PeriodStockAreaReportItem>();

    public StockSummaryReportCompiler(Date endDate) {
        this(endDate, false);
    }

    public StockSummaryReportCompiler(Date endDate, boolean groupedByStockArea) {
        DateOffsetFunction weekEndingFunction = PeriodReportAdapter.WEEK_ENDING.getDateOffset();
        Date start = weekEndingFunction.calcEnd(endDate);
        Date end = weekEndingFunction.calcStart(endDate);
        StockTake startTake = StockTake.getLastStockTakeForDate(start);
        StockTake endTake = StockTake.getLastStockTakeForDate(end);
        if (endTake != null && endTake.equals(startTake)) {
            endTake = null;
        }
        this.compileReport(startTake, endTake, groupedByStockArea);
    }

    private void compileReport(StockTake startTake, StockTake endTake, boolean groupedByStockArea) {
        if (startTake == null) {
            this.createBlankReports(groupedByStockArea);
            return;
        }
        PeriodStockAreaReport superReport = new PeriodStockAreaReport(startTake, endTake);
        List<PeriodStockAreaReportItem> subReports = superReport.getReportItems(StockArea.getStockAreas());
        if (groupedByStockArea) {
            this.reportList.addAll(subReports);
        } else {
            PeriodStockAreaReportItem summaryReport = new PeriodStockAreaReportItem(null, null);
            for (PeriodStockAreaReportItem nextItem : subReports) {
                summaryReport.add(nextItem);
            }
            this.reportList.add(summaryReport);
        }
    }

    public List<PeriodStockAreaReportItem> getReportList() {
        return this.reportList;
    }

    private void createBlankReports(boolean groupedByStockArea) {
        this.reportList.clear();
        if (groupedByStockArea) {
            for (StockArea area : StockArea.getStockAreas()) {
                this.reportList.add(new PeriodStockAreaReportItem(area, null));
            }
        } else {
            this.reportList.add(new PeriodStockAreaReportItem(null, null));
        }
    }
}

