/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary.provider;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.dailysummary.DailyDebtorSummaryReport;
import ordermate.database.reports.dailysummary.DailyDebtorSummaryReportCompiler;
import ordermate.database.reports.dailysummary.provider.AbstractDailySubReportProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.searchers.reports.dailysummary.DailyDebtorSummaryReportSearcher;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.impl.GenericBiListTableModel;

class DailySummaryDebtorProvider
extends AbstractDailySubReportProvider {
    private static final String DEBTOR_SUMMARY = "DAILY_DEBTOR_ACTIVITY";

    DailySummaryDebtorProvider(DailySummaryReportProvider me) {
        super(me);
    }

    @Override
    void addReport(ReportBuilder superBuilder) {
        this.addDebtorSubReport(superBuilder);
    }

    private void addDebtorSubReport(ReportBuilder superBuilder) {
        DailyDebtorSummaryReportSearcher debtorSearcher = this.superProvider.getSearcher().getDebtorSearcher();
        List<DailyDebtorSummaryReport> paymentsReports = debtorSearcher.search();
        List<DailyDebtorSummaryReport> salesReports = PersistenceManager.getObjectList(DailyDebtorSummaryReport.class, debtorSearcher.getSalesQuery().toString());
        List<DailyDebtorSummaryReport> adjustmentsReports = PersistenceManager.getObjectList(DailyDebtorSummaryReport.class, debtorSearcher.getAdjustmentsQuery().toString());
        DailyDebtorSummaryReportCompiler compiler = new DailyDebtorSummaryReportCompiler(paymentsReports, salesReports, adjustmentsReports);
        this.superProvider.getParameters().put(DEBTOR_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder("Daily Debtor Activity", false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), DEBTOR_SUMMARY, 0, 10);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate debtor sales/payments subreport :", (Throwable)ex);
        }
    }
}

