/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary.provider;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import java.util.List;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.dailysummary.DailyKTSReport;
import ordermate.database.reports.dailysummary.DailyKTSReportCompiler;
import ordermate.database.reports.dailysummary.provider.AbstractDailySubReportProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.searchers.reports.dailysummary.DailyKTSReportSearcher;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.impl.GenericBiListTableModel;

class DailySummaryKTSProvider
extends AbstractDailySubReportProvider {
    private static final String KTS_SUMMARY = "DAILY_KTS_STATISTICS";

    public DailySummaryKTSProvider(DailySummaryReportProvider yourProvider) {
        super(yourProvider);
    }

    @Override
    void addReport(ReportBuilder superBuilder) {
        boolean dayParts;
        List<DayPart> parts = this.superProvider.getSearcher().getParams().getDayParts();
        boolean bl = dayParts = parts != null && parts.size() > 1;
        if (dayParts) {
            this.doDayParts(superBuilder, parts);
        }
        this.doFullReport(superBuilder, dayParts);
    }

    private void doDayParts(ReportBuilder superBuilder, List<DayPart> parts) {
        for (DayPart dayPart : parts) {
            DailyKTSReportSearcher ktsSearcher = this.superProvider.getSearcher().getKTSSearcher();
            ktsSearcher.getDayPartFilter().setDayPart(dayPart);
            List<DailyKTSReport> reports = ktsSearcher.search();
            DailyKTSReportCompiler compiler = new DailyKTSReportCompiler(reports);
            this.superProvider.getParameters().put(KTS_SUMMARY + dayPart, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
            try {
                superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder("Daily KTS Statistics - " + dayPart, false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), KTS_SUMMARY + dayPart, 0, 10);
            }
            catch (DJBuilderException ex) {
                OrderMate.LOG.error("Cannot instantiate kts subreport :", (Throwable)ex);
            }
        }
    }

    private void doFullReport(ReportBuilder superBuilder, boolean asTotal) {
        String title = "";
        title = asTotal ? "Daily KTS Statistics - Total" : "Daily KTS Statistics";
        DailyKTSReportSearcher ktsSearcher = this.superProvider.getSearcher().getKTSSearcher();
        ktsSearcher.getDayPartFilter().setDayPart(null);
        ktsSearcher.getDayPartFilter().setAllDay(true);
        List<DailyKTSReport> reports = ktsSearcher.search();
        DailyKTSReportCompiler compiler = new DailyKTSReportCompiler(reports);
        this.superProvider.getParameters().put(KTS_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder(title, false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), KTS_SUMMARY, 0, 10);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate kts subreport :", (Throwable)ex);
        }
    }
}

