/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary.provider;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import java.util.List;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.integration.labour.LabourIntegration;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReport;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReportCompiler;
import ordermate.database.reports.dailysummary.provider.AbstractDailySubReportProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.searchers.reports.dailysummary.DailyProductivitySummaryReportSearcher;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.impl.GenericBiListTableModel;

class DailySummaryProductivityProvider
extends AbstractDailySubReportProvider {
    private static final String PRODUCTIVITY_SUMMARY = "DAILY_PRODUCTIVITY";

    DailySummaryProductivityProvider(DailySummaryReportProvider superProvider) {
        super(superProvider);
    }

    @Override
    void addReport(ReportBuilder superBuilder) {
        String title = "";
        title = LabourIntegration.getInstance().isActive() ? "Daily Productivity (ZUUS Data)" : "Daily Productivity";
        DailyProductivitySummaryReportSearcher productivitySearcher = this.superProvider.getSearcher().getProductivitySearcher();
        List<DailyProductivitySummaryReport> reports = productivitySearcher.search();
        DailyProductivitySummaryReportCompiler compiler = new DailyProductivitySummaryReportCompiler(this.superProvider.getSearcher().getParams().getStart());
        compiler.compile(reports, this.superProvider.getPatrons(null, null), this.superProvider.getTotalSales());
        this.superProvider.getParameters().put(PRODUCTIVITY_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder(title, false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), PRODUCTIVITY_SUMMARY, 0, 10, true);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate productivity subreport :", (Throwable)ex);
        }
    }
}

