/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary.provider;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.database.reports.dailysummary.provider.DailySummaryDebtorProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryKTSProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryProductivityProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryReconciliationProvider;
import ordermate.database.reports.dailysummary.provider.DailySummarySalesProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryStockControlProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryVoucherProvider;
import ordermate.database.searchers.reports.dailysummary.DailyNumPatronsByAccountSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcher;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import org.apache.commons.collections.keyvalue.MultiKey;

public class DailySummaryReportProvider
extends AbstractReportProvider {
    private DailySummaryReportSearcher searcher;
    private Map<MultiKey, List<DailyPatronsReport>> patronsMap = null;
    private List<DailySalesSummaryReport> totalSales = null;
    private boolean byLocation = false;
    private final String DAILY_SUMMARY_FOOTER_LEGEND = "* = Excludes Tax, ^ = After Discounts & Surcharges";

    public DailySummaryReportProvider(boolean breakDownByLocation) {
        this.byLocation = breakDownByLocation;
        this.searcher = new DailySummaryReportSearcher(DayPart.getAllDayParts(true));
    }

    public DailySummaryReportProvider(DailySummaryReportParameters params, boolean breakDownByLocation) {
        this.byLocation = breakDownByLocation;
        this.searcher = new DailySummaryReportSearcher(DayPart.getAllDayParts(true));
        Date startTime = DateTimeUtils.getStartDateForWeek(params.getStart());
        ((TradingDayDateRangeFilterAdapter)params.getTradingDayDateRangeAdapter()).getUnderlyingFilter().setStart(startTime);
        ((TradingDayDateRangeFilterAdapter)params.getTradingDayDateRangeAdapter()).getUnderlyingFilter().setEnd(DateTimeUtils.getEndDateForWeek(startTime));
        this.searcher.setParams(params);
    }

    public DailySummaryReportSearcher getSearcher() {
        return this.searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanArrayDataSource(new Object[]{"DummyData"});
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public synchronized ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        StringBuilder SB = new StringBuilder("Daily Summary ");
        if (this.byLocation) {
            SB.append(" by Location");
        } else {
            SB.append(" by Account Type");
        }
        SB.append(" - ");
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getParams().getTradingDayDateRangeAdapter(), null);
        builder.setTitle(SB.toString());
        SB = new StringBuilder();
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.searcher.getParams().getSalesLocationsFilter());
        builder.setSubtitle(SB.toString());
        this.makePatronsSummary(this.searcher.getParams());
        this.addSalesSubReport(builder);
        this.addDebtorSubReport(builder);
        this.addVoucherSubReport(builder);
        this.addReconciliationSubReport(builder);
        this.addProductivitySubReport(builder);
        this.addStockControlSubReport(builder);
        if (PersistenceManager.getObject(KTSDocketPrinter.class, Query.select(KTSDocketPrinter.class).active(KTSDocketPrinter.class).toString()) != null) {
            this.addKTSData(builder);
        }
        return builder;
    }

    private void addSalesSubReport(ReportBuilder superBuilder) {
        this.validateThreadState();
        DailySummarySalesProvider provider = new DailySummarySalesProvider(this);
        provider.addReport(superBuilder);
        this.totalSales = provider.getTotalSales();
    }

    private void addStockControlSubReport(ReportBuilder superBuilder) {
        this.validateThreadState();
        if (SystemProperty.getInstance().isStockControlEnabled()) {
            new DailySummaryStockControlProvider(this).addReport(superBuilder);
        }
    }

    private void addDebtorSubReport(ReportBuilder superBuilder) {
        this.validateThreadState();
        new DailySummaryDebtorProvider(this).addReport(superBuilder);
    }

    private void addVoucherSubReport(ReportBuilder superBuilder) {
        this.validateThreadState();
        new DailySummaryVoucherProvider(this).addReport(superBuilder);
    }

    private void addProductivitySubReport(ReportBuilder superBuilder) {
        this.validateThreadState();
        new DailySummaryProductivityProvider(this).addReport(superBuilder);
    }

    private void addReconciliationSubReport(ReportBuilder superBuilder) {
        this.validateThreadState();
        new DailySummaryReconciliationProvider(this).addReport(superBuilder);
    }

    private void addKTSData(ReportBuilder superBuilder) {
        this.validateThreadState();
        new DailySummaryKTSProvider(this).addReport(superBuilder);
    }

    private void makePatronsSummary(DailySummaryReportParameters params) {
        this.validateThreadState();
        this.patronsMap = new ConcurrentHashMap<MultiKey, List<DailyPatronsReport>>();
        DailyNumPatronsByAccountSearcher patronsSearcher = this.searcher.getPatronsByAccountSearcher();
        patronsSearcher.setDayPart(null);
        patronsSearcher.setLocation(null);
        this.patronsMap.put(new MultiKey(null, null), this.removeNullDayReports(patronsSearcher.search()));
        if (this.byLocation) {
            for (SalesLocation location : SalesLocation.getSalesLocations()) {
                patronsSearcher.setLocation(location);
                for (DayPart dayPart : params.getDayParts()) {
                    patronsSearcher.setDayPart(dayPart);
                    this.patronsMap.put(new MultiKey((Object)location, (Object)dayPart), this.removeNullDayReports(patronsSearcher.search()));
                }
                patronsSearcher.setDayPart(null);
                this.patronsMap.put(new MultiKey((Object)location, null), this.removeNullDayReports(patronsSearcher.search()));
            }
        }
        patronsSearcher.setLocation(null);
        for (DayPart dayPart : params.getDayParts()) {
            patronsSearcher.setDayPart(dayPart);
            this.patronsMap.put(new MultiKey(null, (Object)dayPart), this.removeNullDayReports(patronsSearcher.search()));
        }
    }

    private List<DailyPatronsReport> removeNullDayReports(List<DailyPatronsReport> reports) {
        for (DailyPatronsReport report : reports) {
            if (report.getDayOfWeek() != null) continue;
            reports.remove(report);
            break;
        }
        return reports;
    }

    List<DailyPatronsReport> getPatrons(SalesLocation location, DayPart part) {
        return this.patronsMap.get(new MultiKey((Object)location, (Object)part));
    }

    public List<DailySalesSummaryReport> getTotalSales() {
        return this.totalSales;
    }

    public boolean isByLocation() {
        return this.byLocation;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "* = Excludes Tax, ^ = After Discounts & Surcharges\nSales in this report are being filtered based on " + DailySummaryReportSearcher.TRADING_DAY_FK_LINK.getOwner().getSimpleName();
    }
}

