/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary.provider;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.database.reports.dailysummary.DailySalesSummaryReportCompiler;
import ordermate.database.reports.dailysummary.provider.AbstractDailySubReportProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportType;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.impl.GenericBiListTableModel;

class DailySummarySalesProvider
extends AbstractDailySubReportProvider {
    private static final String SALES_SUMMARY = "SALES_SUMMARY_";
    private List<DailySalesSummaryReport> totalSales;

    DailySummarySalesProvider(DailySummaryReportProvider superProvider) {
        super(superProvider);
    }

    @Override
    void addReport(ReportBuilder superBuilder) {
        DailySummaryReportParameters params = this.superProvider.getSearcher().getParams();
        DailySummaryReportType reportType = params.getReportType();
        if (this.superProvider.isByLocation()) {
            List<SalesLocation> locations = params.getSalesLocationsFilter().getSelectedOptions();
            if (locations.isEmpty()) {
                locations = SalesLocation.getSalesLocations();
            }
            for (SalesLocation location : locations) {
                this.addSalesSummaryForLocation(location, superBuilder, reportType, params);
            }
        } else {
            this.addSalesSummaryForLocation(null, superBuilder, reportType, params);
        }
    }

    private void addSalesSummaryForLocation(SalesLocation location, ReportBuilder superBuilder, DailySummaryReportType reportType, DailySummaryReportParameters params) {
        List<DailySalesSummaryReport> salesReportList = this.superProvider.getSearcher().getSalesSearcher().search();
        superBuilder.setTitle("Daily Summary " + reportType.getLabel());
        String dateString = PeriodReportAdapter.WEEK_ENDING.formatTradingDayRangeForDisplay((Date)params.getDateFilter().getStart(), (Date)params.getDateFilter().getEnd(), params.getEnd());
        superBuilder.setSubtitle("Week Ending: " + dateString);
        List<DayPart> parts = params.getDayParts();
        if (parts.size() > 1) {
            for (DayPart part : parts) {
                DailySalesSummaryReportCompiler compiler = new DailySalesSummaryReportCompiler(location, part, salesReportList, reportType, this.superProvider.getPatrons(location, part));
                try {
                    this.addDailySalesSubReport(location, part, compiler, superBuilder);
                }
                catch (DJBuilderException ex) {
                    OrderMate.LOG.error("Cannot build summary report : ", (Throwable)ex);
                }
            }
        }
        DailySalesSummaryReportCompiler totalCompiler = new DailySalesSummaryReportCompiler(location, null, salesReportList, reportType, this.superProvider.getPatrons(location, null));
        try {
            this.addDailySalesSubReport(location, null, totalCompiler, superBuilder);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot build total summary report : ", (Throwable)ex);
        }
    }

    private void addDailySalesSubReport(SalesLocation location, DayPart part, DailySalesSummaryReportCompiler compiler, ReportBuilder superBuilder) throws DJBuilderException {
        String dataLabel = part == null ? "SALES_SUMMARY_Total" : SALES_SUMMARY + part.getLabel();
        dataLabel = dataLabel + (location == null ? "ALL" : location.getLabel());
        JRTableModelDataSource source = new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData()));
        this.superProvider.getParameters().put(dataLabel, source);
        ReportBuilder subReportBuilder = new ReportBuilder();
        subReportBuilder.getReportBuilder().setAllowDetailSplit(false);
        subReportBuilder.setTitle(this.makeSalesTitle(location, part));
        List<String> colNames = compiler.getColumnNames();
        for (int i = 0; i < colNames.size(); ++i) {
            String name = colNames.get(i);
            ColumnProperty prop = new ColumnProperty(name, String.class);
            SimpleColumn column = new SimpleColumn();
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name);
            subReportBuilder.getReportBuilder().addColumn((AbstractColumn)column);
            column.getStyle().getFont().setBold(false);
            column.getStyle().getFont().setFontSize(8);
            if (i == 0) {
                column.setStyle(JasperReportHelper.leftAlignStyle(column.getStyle()));
                continue;
            }
            column.setStyle(JasperReportHelper.rightAlignStyle(column.getStyle()));
        }
        superBuilder.getReportBuilder().addConcatenatedReport(subReportBuilder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), dataLabel, 0, 10);
        this.totalSales = compiler.getTotalSales();
    }

    public List<DailySalesSummaryReport> getTotalSales() {
        return this.totalSales;
    }

    private String makeSalesTitle(SalesLocation location, DayPart part) {
        StringBuilder SB = new StringBuilder();
        if (part == null) {
            SB.append("Total");
        } else {
            SB.append(part.getLabel());
        }
        SB.append(" For ");
        if (location == null) {
            SB.append("All Locations");
        } else {
            SB.append(location.getLabel());
        }
        return SB.toString();
    }
}

