/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.dailysummary.provider;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import java.awt.Color;
import java.util.Calendar;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.reports.dailysummary.StockSummaryReportCompiler;
import ordermate.database.reports.dailysummary.provider.AbstractDailySubReportProvider;
import ordermate.database.reports.dailysummary.provider.DailySummaryReportProvider;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;
import ordermate.database.stock.StockTake;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;

class DailySummaryStockControlProvider
extends AbstractDailySubReportProvider {
    private static final String STOCK_SUMMARY = "STOCK_SUMMARY";
    private static final String STOCK_BROKEN_DOWN_BY_AREA = "Stock Broken Down By Area";

    DailySummaryStockControlProvider(DailySummaryReportProvider yourProvider) {
        super(yourProvider);
    }

    @Override
    void addReport(ReportBuilder builder) {
        this.addStockControlSubReport(builder);
    }

    private void addStockControlSubReport(ReportBuilder superBuilder) {
        StockTake take = StockTake.getLastSavedStockTake();
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        if (take == null || cal.getTime().after(take.getDate())) {
            OrderMate.LOG.info("Will not perform Stock Control Summary for Daily Summary Report : Stocktake has not been completed in over a year.");
            return;
        }
        ReportBuilder builder = new ReportBuilder(new OrderMateDefaultReportStyle(){

            @Override
            protected Style constructColumnHeaderStyle() {
                Style style = new Style();
                style.setFont(Font.ARIAL_SMALL_BOLD);
                style.setBorderTop(Border.PEN_2_POINT);
                style.setBorderBottom(Border.THIN);
                style.setBackgroundColor(Color.black);
                style.setTransparency(Transparency.OPAQUE);
                style.setTextColor(Color.white);
                style.setHorizontalAlign(HorizontalAlign.CENTER);
                style.setVerticalAlign(VerticalAlign.MIDDLE);
                return style;
            }
        });
        DailySummaryReportParameters params = this.superProvider.getSearcher().getParams();
        boolean stockBrokenDownByArea = Boolean.TRUE.equals(ReportProperty.find(ReportGroup.DailySummary, STOCK_BROKEN_DOWN_BY_AREA).getBooleanValue(Boolean.FALSE));
        StockSummaryReportCompiler compiler = new StockSummaryReportCompiler(params.getEnd(), stockBrokenDownByArea);
        this.superProvider.getParameters().put(STOCK_SUMMARY, new JRBeanCollectionDataSource(compiler.getReportList()));
        try {
            if (stockBrokenDownByArea) {
                builder.addReportColumn(PeriodStockAreaReportItem.Properties.AREA, "Area");
            }
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.OPENING_STOCK, "Opening", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.PURCHASES, "Purchases", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.ADJUSTMENTS, "Adjustments", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.WASTAGE, "Wastage", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.YIELD, "Yield", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.CLOSING_STOCK, "Closing", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.STOCKTAKE_VAR, "Variance", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.COGS, "CoGs $", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.COGS_PERC, "CoGs %", "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.GP, "GP $", Internationalization.getLiteralFor("PRICE_PATTERN"));
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.GP_PERC, "GP %", "0.00");
        }
        catch (ColumnBuilderException ex) {
            OrderMate.LOG.error("Error with constructing the StockControlSubReport in DailySummaryReportProvider:", (Throwable)ex);
        }
        builder.setTitle("Stock Summary");
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(builder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), STOCK_SUMMARY, 0, 10);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate debtor sales/payments subreport :", (Throwable)ex);
        }
    }
}

